/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.BackupsLongTermRetentionsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.BackupsLongTermRetentionOperationInner;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.BackupsLongTermRetentionResponseInner;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.LtrPreBackupResponseInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.BackupsLongTermRetentionOperationImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.BackupsLongTermRetentionResponseImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.LtrPreBackupResponseImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupsLongTermRetentionOperation;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupsLongTermRetentionRequest;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupsLongTermRetentionResponse;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupsLongTermRetentions;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupsLongTermRetentionsCheckPrerequisitesResponse;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LtrPreBackupRequest;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LtrPreBackupResponse;

public final class BackupsLongTermRetentionsImpl
implements BackupsLongTermRetentions {
    private static final ClientLogger LOGGER = new ClientLogger(BackupsLongTermRetentionsImpl.class);
    private final BackupsLongTermRetentionsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public BackupsLongTermRetentionsImpl(BackupsLongTermRetentionsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<LtrPreBackupResponse> checkPrerequisitesWithResponse(String resourceGroupName, String serverName, LtrPreBackupRequest parameters, Context context) {
        BackupsLongTermRetentionsCheckPrerequisitesResponse inner = this.serviceClient().checkPrerequisitesWithResponse(resourceGroupName, serverName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LtrPreBackupResponseImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public LtrPreBackupResponse checkPrerequisites(String resourceGroupName, String serverName, LtrPreBackupRequest parameters) {
        LtrPreBackupResponseInner inner = this.serviceClient().checkPrerequisites(resourceGroupName, serverName, parameters);
        if (inner != null) {
            return new LtrPreBackupResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BackupsLongTermRetentionResponse start(String resourceGroupName, String serverName, BackupsLongTermRetentionRequest parameters) {
        BackupsLongTermRetentionResponseInner inner = this.serviceClient().start(resourceGroupName, serverName, parameters);
        if (inner != null) {
            return new BackupsLongTermRetentionResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BackupsLongTermRetentionResponse start(String resourceGroupName, String serverName, BackupsLongTermRetentionRequest parameters, Context context) {
        BackupsLongTermRetentionResponseInner inner = this.serviceClient().start(resourceGroupName, serverName, parameters, context);
        if (inner != null) {
            return new BackupsLongTermRetentionResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<BackupsLongTermRetentionOperation> getWithResponse(String resourceGroupName, String serverName, String backupName, Context context) {
        Response<BackupsLongTermRetentionOperationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, backupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackupsLongTermRetentionOperationImpl((BackupsLongTermRetentionOperationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BackupsLongTermRetentionOperation get(String resourceGroupName, String serverName, String backupName) {
        BackupsLongTermRetentionOperationInner inner = this.serviceClient().get(resourceGroupName, serverName, backupName);
        if (inner != null) {
            return new BackupsLongTermRetentionOperationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<BackupsLongTermRetentionOperation> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<BackupsLongTermRetentionOperationInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupsLongTermRetentionOperationImpl((BackupsLongTermRetentionOperationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BackupsLongTermRetentionOperation> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<BackupsLongTermRetentionOperationInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupsLongTermRetentionOperationImpl((BackupsLongTermRetentionOperationInner)((Object)inner1), this.manager()));
    }

    private BackupsLongTermRetentionsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

