/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.BackupsAutomaticAndOnDemandsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.BackupAutomaticAndOnDemandInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.BackupAutomaticAndOnDemandImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupAutomaticAndOnDemand;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupsAutomaticAndOnDemands;

public final class BackupsAutomaticAndOnDemandsImpl
implements BackupsAutomaticAndOnDemands {
    private static final ClientLogger LOGGER = new ClientLogger(BackupsAutomaticAndOnDemandsImpl.class);
    private final BackupsAutomaticAndOnDemandsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public BackupsAutomaticAndOnDemandsImpl(BackupsAutomaticAndOnDemandsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public BackupAutomaticAndOnDemand create(String resourceGroupName, String serverName, String backupName) {
        BackupAutomaticAndOnDemandInner inner = this.serviceClient().create(resourceGroupName, serverName, backupName);
        if (inner != null) {
            return new BackupAutomaticAndOnDemandImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BackupAutomaticAndOnDemand create(String resourceGroupName, String serverName, String backupName, Context context) {
        BackupAutomaticAndOnDemandInner inner = this.serviceClient().create(resourceGroupName, serverName, backupName, context);
        if (inner != null) {
            return new BackupAutomaticAndOnDemandImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String backupName) {
        this.serviceClient().delete(resourceGroupName, serverName, backupName);
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String backupName, Context context) {
        this.serviceClient().delete(resourceGroupName, serverName, backupName, context);
    }

    @Override
    public Response<BackupAutomaticAndOnDemand> getWithResponse(String resourceGroupName, String serverName, String backupName, Context context) {
        Response<BackupAutomaticAndOnDemandInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, backupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackupAutomaticAndOnDemandImpl((BackupAutomaticAndOnDemandInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BackupAutomaticAndOnDemand get(String resourceGroupName, String serverName, String backupName) {
        BackupAutomaticAndOnDemandInner inner = this.serviceClient().get(resourceGroupName, serverName, backupName);
        if (inner != null) {
            return new BackupAutomaticAndOnDemandImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<BackupAutomaticAndOnDemand> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<BackupAutomaticAndOnDemandInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupAutomaticAndOnDemandImpl((BackupAutomaticAndOnDemandInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BackupAutomaticAndOnDemand> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<BackupAutomaticAndOnDemandInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupAutomaticAndOnDemandImpl((BackupAutomaticAndOnDemandInner)((Object)inner1), this.manager()));
    }

    private BackupsAutomaticAndOnDemandsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

