/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.AdministratorsMicrosoftEntrasClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.AdministratorMicrosoftEntraInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.AdministratorMicrosoftEntraImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AdministratorMicrosoftEntra;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AdministratorsMicrosoftEntras;

public final class AdministratorsMicrosoftEntrasImpl
implements AdministratorsMicrosoftEntras {
    private static final ClientLogger LOGGER = new ClientLogger(AdministratorsMicrosoftEntrasImpl.class);
    private final AdministratorsMicrosoftEntrasClient innerClient;
    private final PostgreSqlManager serviceManager;

    public AdministratorsMicrosoftEntrasImpl(AdministratorsMicrosoftEntrasClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String objectId) {
        this.serviceClient().delete(resourceGroupName, serverName, objectId);
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String objectId, Context context) {
        this.serviceClient().delete(resourceGroupName, serverName, objectId, context);
    }

    @Override
    public Response<AdministratorMicrosoftEntra> getWithResponse(String resourceGroupName, String serverName, String objectId, Context context) {
        Response<AdministratorMicrosoftEntraInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, objectId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AdministratorMicrosoftEntraImpl((AdministratorMicrosoftEntraInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AdministratorMicrosoftEntra get(String resourceGroupName, String serverName, String objectId) {
        AdministratorMicrosoftEntraInner inner = this.serviceClient().get(resourceGroupName, serverName, objectId);
        if (inner != null) {
            return new AdministratorMicrosoftEntraImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<AdministratorMicrosoftEntra> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<AdministratorMicrosoftEntraInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AdministratorMicrosoftEntraImpl((AdministratorMicrosoftEntraInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AdministratorMicrosoftEntra> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<AdministratorMicrosoftEntraInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AdministratorMicrosoftEntraImpl((AdministratorMicrosoftEntraInner)((Object)inner1), this.manager()));
    }

    @Override
    public AdministratorMicrosoftEntra getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String objectId = ResourceManagerUtils.getValueFromIdByName(id, "administrators");
        if (objectId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        return (AdministratorMicrosoftEntra)this.getWithResponse(resourceGroupName, serverName, objectId, Context.NONE).getValue();
    }

    @Override
    public Response<AdministratorMicrosoftEntra> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String objectId = ResourceManagerUtils.getValueFromIdByName(id, "administrators");
        if (objectId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, objectId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String objectId = ResourceManagerUtils.getValueFromIdByName(id, "administrators");
        if (objectId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        this.delete(resourceGroupName, serverName, objectId, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String objectId = ResourceManagerUtils.getValueFromIdByName(id, "administrators");
        if (objectId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'administrators'.", id)));
        }
        this.delete(resourceGroupName, serverName, objectId, context);
    }

    private AdministratorsMicrosoftEntrasClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public AdministratorMicrosoftEntraImpl define(String name) {
        return new AdministratorMicrosoftEntraImpl(name, this.manager());
    }
}

