/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.AdministratorMicrosoftEntraInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AdministratorMicrosoftEntra;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AdministratorMicrosoftEntraAdd;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrincipalType;

public final class AdministratorMicrosoftEntraImpl
implements AdministratorMicrosoftEntra,
AdministratorMicrosoftEntra.Definition,
AdministratorMicrosoftEntra.Update {
    private AdministratorMicrosoftEntraInner innerObject;
    private final PostgreSqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private String objectId;
    private AdministratorMicrosoftEntraAdd createParameters;
    private AdministratorMicrosoftEntraAdd updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public PrincipalType principalType() {
        return this.innerModel().principalType();
    }

    @Override
    public String principalName() {
        return this.innerModel().principalName();
    }

    @Override
    public String objectId() {
        return this.innerModel().objectId();
    }

    @Override
    public String tenantId() {
        return this.innerModel().tenantId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AdministratorMicrosoftEntraInner innerModel() {
        return this.innerObject;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public AdministratorMicrosoftEntraImpl withExistingFlexibleServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public AdministratorMicrosoftEntra create() {
        this.innerObject = this.serviceManager.serviceClient().getAdministratorsMicrosoftEntras().createOrUpdate(this.resourceGroupName, this.serverName, this.objectId, this.createParameters, Context.NONE);
        return this;
    }

    @Override
    public AdministratorMicrosoftEntra create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAdministratorsMicrosoftEntras().createOrUpdate(this.resourceGroupName, this.serverName, this.objectId, this.createParameters, context);
        return this;
    }

    AdministratorMicrosoftEntraImpl(String name, PostgreSqlManager serviceManager) {
        this.innerObject = new AdministratorMicrosoftEntraInner();
        this.serviceManager = serviceManager;
        this.objectId = name;
        this.createParameters = new AdministratorMicrosoftEntraAdd();
    }

    @Override
    public AdministratorMicrosoftEntraImpl update() {
        this.updateParameters = new AdministratorMicrosoftEntraAdd();
        return this;
    }

    @Override
    public AdministratorMicrosoftEntra apply() {
        this.innerObject = this.serviceManager.serviceClient().getAdministratorsMicrosoftEntras().createOrUpdate(this.resourceGroupName, this.serverName, this.objectId, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public AdministratorMicrosoftEntra apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAdministratorsMicrosoftEntras().createOrUpdate(this.resourceGroupName, this.serverName, this.objectId, this.updateParameters, context);
        return this;
    }

    AdministratorMicrosoftEntraImpl(AdministratorMicrosoftEntraInner innerObject, PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "flexibleServers");
        this.objectId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "administrators");
    }

    @Override
    public AdministratorMicrosoftEntra refresh() {
        this.innerObject = (AdministratorMicrosoftEntraInner)((Object)this.serviceManager.serviceClient().getAdministratorsMicrosoftEntras().getWithResponse(this.resourceGroupName, this.serverName, this.objectId, Context.NONE).getValue());
        return this;
    }

    @Override
    public AdministratorMicrosoftEntra refresh(Context context) {
        this.innerObject = (AdministratorMicrosoftEntraInner)((Object)this.serviceManager.serviceClient().getAdministratorsMicrosoftEntras().getWithResponse(this.resourceGroupName, this.serverName, this.objectId, context).getValue());
        return this;
    }

    @Override
    public AdministratorMicrosoftEntraImpl withPrincipalType(PrincipalType principalType) {
        if (this.isInCreateMode()) {
            this.createParameters.withPrincipalType(principalType);
            return this;
        }
        this.updateParameters.withPrincipalType(principalType);
        return this;
    }

    @Override
    public AdministratorMicrosoftEntraImpl withPrincipalName(String principalName) {
        if (this.isInCreateMode()) {
            this.createParameters.withPrincipalName(principalName);
            return this;
        }
        this.updateParameters.withPrincipalName(principalName);
        return this;
    }

    @Override
    public AdministratorMicrosoftEntraImpl withTenantId(String tenantId) {
        if (this.isInCreateMode()) {
            this.createParameters.withTenantId(tenantId);
            return this;
        }
        this.updateParameters.withTenantId(tenantId);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

