/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PostgreSqlManagementClient;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.AdministratorsMicrosoftEntrasImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.AdvancedThreatProtectionSettingsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.BackupsAutomaticAndOnDemandsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.BackupsLongTermRetentionsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.CapabilitiesByLocationsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.CapabilitiesByServersImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.CapturedLogsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ConfigurationsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.DatabasesImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.FirewallRulesImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.MigrationsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.NameAvailabilitiesImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.OperationsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PostgreSqlManagementClientBuilder;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PrivateDnsZoneSuffixesImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.QuotaUsagesImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ReplicasImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ServerThreatProtectionSettingsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ServersImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.TuningOptionsOperationsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.VirtualEndpointsImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.VirtualNetworkSubnetUsagesImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AdministratorsMicrosoftEntras;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AdvancedThreatProtectionSettings;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupsAutomaticAndOnDemands;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupsLongTermRetentions;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilitiesByLocations;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilitiesByServers;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapturedLogs;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Configurations;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Databases;
import com.azure.resourcemanager.postgresqlflexibleserver.models.FirewallRules;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Migrations;
import com.azure.resourcemanager.postgresqlflexibleserver.models.NameAvailabilities;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Operations;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrivateDnsZoneSuffixes;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrivateEndpointConnections;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrivateLinkResources;
import com.azure.resourcemanager.postgresqlflexibleserver.models.QuotaUsages;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replicas;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerThreatProtectionSettings;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Servers;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TuningOptionsOperations;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpoints;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualNetworkSubnetUsages;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class PostgreSqlManager {
    private AdministratorsMicrosoftEntras administratorsMicrosoftEntras;
    private AdvancedThreatProtectionSettings advancedThreatProtectionSettings;
    private ServerThreatProtectionSettings serverThreatProtectionSettings;
    private BackupsAutomaticAndOnDemands backupsAutomaticAndOnDemands;
    private CapabilitiesByLocations capabilitiesByLocations;
    private CapabilitiesByServers capabilitiesByServers;
    private CapturedLogs capturedLogs;
    private Configurations configurations;
    private Databases databases;
    private FirewallRules firewallRules;
    private BackupsLongTermRetentions backupsLongTermRetentions;
    private Migrations migrations;
    private NameAvailabilities nameAvailabilities;
    private Operations operations;
    private PrivateDnsZoneSuffixes privateDnsZoneSuffixes;
    private PrivateEndpointConnections privateEndpointConnections;
    private PrivateLinkResources privateLinkResources;
    private QuotaUsages quotaUsages;
    private Replicas replicas;
    private Servers servers;
    private TuningOptionsOperations tuningOptionsOperations;
    private VirtualEndpoints virtualEndpoints;
    private VirtualNetworkSubnetUsages virtualNetworkSubnetUsages;
    private final PostgreSqlManagementClient clientObject;

    private PostgreSqlManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new PostgreSqlManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static PostgreSqlManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return PostgreSqlManager.configure().authenticate(credential, profile);
    }

    public static PostgreSqlManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new PostgreSqlManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public AdministratorsMicrosoftEntras administratorsMicrosoftEntras() {
        if (this.administratorsMicrosoftEntras == null) {
            this.administratorsMicrosoftEntras = new AdministratorsMicrosoftEntrasImpl(this.clientObject.getAdministratorsMicrosoftEntras(), this);
        }
        return this.administratorsMicrosoftEntras;
    }

    public AdvancedThreatProtectionSettings advancedThreatProtectionSettings() {
        if (this.advancedThreatProtectionSettings == null) {
            this.advancedThreatProtectionSettings = new AdvancedThreatProtectionSettingsImpl(this.clientObject.getAdvancedThreatProtectionSettings(), this);
        }
        return this.advancedThreatProtectionSettings;
    }

    public ServerThreatProtectionSettings serverThreatProtectionSettings() {
        if (this.serverThreatProtectionSettings == null) {
            this.serverThreatProtectionSettings = new ServerThreatProtectionSettingsImpl(this.clientObject.getServerThreatProtectionSettings(), this);
        }
        return this.serverThreatProtectionSettings;
    }

    public BackupsAutomaticAndOnDemands backupsAutomaticAndOnDemands() {
        if (this.backupsAutomaticAndOnDemands == null) {
            this.backupsAutomaticAndOnDemands = new BackupsAutomaticAndOnDemandsImpl(this.clientObject.getBackupsAutomaticAndOnDemands(), this);
        }
        return this.backupsAutomaticAndOnDemands;
    }

    public CapabilitiesByLocations capabilitiesByLocations() {
        if (this.capabilitiesByLocations == null) {
            this.capabilitiesByLocations = new CapabilitiesByLocationsImpl(this.clientObject.getCapabilitiesByLocations(), this);
        }
        return this.capabilitiesByLocations;
    }

    public CapabilitiesByServers capabilitiesByServers() {
        if (this.capabilitiesByServers == null) {
            this.capabilitiesByServers = new CapabilitiesByServersImpl(this.clientObject.getCapabilitiesByServers(), this);
        }
        return this.capabilitiesByServers;
    }

    public CapturedLogs capturedLogs() {
        if (this.capturedLogs == null) {
            this.capturedLogs = new CapturedLogsImpl(this.clientObject.getCapturedLogs(), this);
        }
        return this.capturedLogs;
    }

    public Configurations configurations() {
        if (this.configurations == null) {
            this.configurations = new ConfigurationsImpl(this.clientObject.getConfigurations(), this);
        }
        return this.configurations;
    }

    public Databases databases() {
        if (this.databases == null) {
            this.databases = new DatabasesImpl(this.clientObject.getDatabases(), this);
        }
        return this.databases;
    }

    public FirewallRules firewallRules() {
        if (this.firewallRules == null) {
            this.firewallRules = new FirewallRulesImpl(this.clientObject.getFirewallRules(), this);
        }
        return this.firewallRules;
    }

    public BackupsLongTermRetentions backupsLongTermRetentions() {
        if (this.backupsLongTermRetentions == null) {
            this.backupsLongTermRetentions = new BackupsLongTermRetentionsImpl(this.clientObject.getBackupsLongTermRetentions(), this);
        }
        return this.backupsLongTermRetentions;
    }

    public Migrations migrations() {
        if (this.migrations == null) {
            this.migrations = new MigrationsImpl(this.clientObject.getMigrations(), this);
        }
        return this.migrations;
    }

    public NameAvailabilities nameAvailabilities() {
        if (this.nameAvailabilities == null) {
            this.nameAvailabilities = new NameAvailabilitiesImpl(this.clientObject.getNameAvailabilities(), this);
        }
        return this.nameAvailabilities;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public PrivateDnsZoneSuffixes privateDnsZoneSuffixes() {
        if (this.privateDnsZoneSuffixes == null) {
            this.privateDnsZoneSuffixes = new PrivateDnsZoneSuffixesImpl(this.clientObject.getPrivateDnsZoneSuffixes(), this);
        }
        return this.privateDnsZoneSuffixes;
    }

    public PrivateEndpointConnections privateEndpointConnections() {
        if (this.privateEndpointConnections == null) {
            this.privateEndpointConnections = new PrivateEndpointConnectionsImpl(this.clientObject.getPrivateEndpointConnections(), this);
        }
        return this.privateEndpointConnections;
    }

    public PrivateLinkResources privateLinkResources() {
        if (this.privateLinkResources == null) {
            this.privateLinkResources = new PrivateLinkResourcesImpl(this.clientObject.getPrivateLinkResources(), this);
        }
        return this.privateLinkResources;
    }

    public QuotaUsages quotaUsages() {
        if (this.quotaUsages == null) {
            this.quotaUsages = new QuotaUsagesImpl(this.clientObject.getQuotaUsages(), this);
        }
        return this.quotaUsages;
    }

    public Replicas replicas() {
        if (this.replicas == null) {
            this.replicas = new ReplicasImpl(this.clientObject.getReplicas(), this);
        }
        return this.replicas;
    }

    public Servers servers() {
        if (this.servers == null) {
            this.servers = new ServersImpl(this.clientObject.getServers(), this);
        }
        return this.servers;
    }

    public TuningOptionsOperations tuningOptionsOperations() {
        if (this.tuningOptionsOperations == null) {
            this.tuningOptionsOperations = new TuningOptionsOperationsImpl(this.clientObject.getTuningOptionsOperations(), this);
        }
        return this.tuningOptionsOperations;
    }

    public VirtualEndpoints virtualEndpoints() {
        if (this.virtualEndpoints == null) {
            this.virtualEndpoints = new VirtualEndpointsImpl(this.clientObject.getVirtualEndpoints(), this);
        }
        return this.virtualEndpoints;
    }

    public VirtualNetworkSubnetUsages virtualNetworkSubnetUsages() {
        if (this.virtualNetworkSubnetUsages == null) {
            this.virtualNetworkSubnetUsages = new VirtualNetworkSubnetUsagesImpl(this.clientObject.getVirtualNetworkSubnetUsages(), this);
        }
        return this.virtualNetworkSubnetUsages;
    }

    public PostgreSqlManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-postgresqlflexibleserver.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public PostgreSqlManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.postgresqlflexibleserver").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new PostgreSqlManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

