/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwrighttesting.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.playwrighttesting.models.EnablementStatus;
import com.azure.resourcemanager.playwrighttesting.models.ProvisioningState;
import java.io.IOException;

public final class AccountProperties
implements JsonSerializable<AccountProperties> {
    private String dashboardUri;
    private EnablementStatus regionalAffinity;
    private EnablementStatus scalableExecution;
    private EnablementStatus reporting;
    private EnablementStatus localAuth;
    private ProvisioningState provisioningState;

    public String dashboardUri() {
        return this.dashboardUri;
    }

    public EnablementStatus regionalAffinity() {
        return this.regionalAffinity;
    }

    public AccountProperties withRegionalAffinity(EnablementStatus regionalAffinity) {
        this.regionalAffinity = regionalAffinity;
        return this;
    }

    public EnablementStatus scalableExecution() {
        return this.scalableExecution;
    }

    public AccountProperties withScalableExecution(EnablementStatus scalableExecution) {
        this.scalableExecution = scalableExecution;
        return this;
    }

    public EnablementStatus reporting() {
        return this.reporting;
    }

    public AccountProperties withReporting(EnablementStatus reporting) {
        this.reporting = reporting;
        return this;
    }

    public EnablementStatus localAuth() {
        return this.localAuth;
    }

    public AccountProperties withLocalAuth(EnablementStatus localAuth) {
        this.localAuth = localAuth;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("regionalAffinity", this.regionalAffinity == null ? null : this.regionalAffinity.toString());
        jsonWriter.writeStringField("scalableExecution", this.scalableExecution == null ? null : this.scalableExecution.toString());
        jsonWriter.writeStringField("reporting", this.reporting == null ? null : this.reporting.toString());
        jsonWriter.writeStringField("localAuth", this.localAuth == null ? null : this.localAuth.toString());
        return jsonWriter.writeEndObject();
    }

    public static AccountProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AccountProperties)jsonReader.readObject(reader -> {
            AccountProperties deserializedAccountProperties = new AccountProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dashboardUri".equals(fieldName)) {
                    deserializedAccountProperties.dashboardUri = reader.getString();
                    continue;
                }
                if ("regionalAffinity".equals(fieldName)) {
                    deserializedAccountProperties.regionalAffinity = EnablementStatus.fromString(reader.getString());
                    continue;
                }
                if ("scalableExecution".equals(fieldName)) {
                    deserializedAccountProperties.scalableExecution = EnablementStatus.fromString(reader.getString());
                    continue;
                }
                if ("reporting".equals(fieldName)) {
                    deserializedAccountProperties.reporting = EnablementStatus.fromString(reader.getString());
                    continue;
                }
                if ("localAuth".equals(fieldName)) {
                    deserializedAccountProperties.localAuth = EnablementStatus.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAccountProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccountProperties;
        });
    }
}

