/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwrighttesting.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.playwrighttesting.fluent.models.AccountQuotaInner;
import java.io.IOException;
import java.util.List;

public final class AccountQuotaListResult
implements JsonSerializable<AccountQuotaListResult> {
    private List<AccountQuotaInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(AccountQuotaListResult.class);

    private AccountQuotaListResult() {
    }

    public List<AccountQuotaInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model AccountQuotaListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static AccountQuotaListResult fromJson(JsonReader jsonReader) throws IOException {
        return (AccountQuotaListResult)jsonReader.readObject(reader -> {
            AccountQuotaListResult deserializedAccountQuotaListResult = new AccountQuotaListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedAccountQuotaListResult.value = value = reader.readArray(reader1 -> AccountQuotaInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedAccountQuotaListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccountQuotaListResult;
        });
    }
}

