/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwrighttesting.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.playwrighttesting.models.FreeTrialProperties;
import com.azure.resourcemanager.playwrighttesting.models.OfferingType;
import com.azure.resourcemanager.playwrighttesting.models.ProvisioningState;
import java.io.IOException;

public final class QuotaProperties
implements JsonSerializable<QuotaProperties> {
    private FreeTrialProperties freeTrial;
    private OfferingType offeringType;
    private ProvisioningState provisioningState;

    private QuotaProperties() {
    }

    public FreeTrialProperties freeTrial() {
        return this.freeTrial;
    }

    public OfferingType offeringType() {
        return this.offeringType;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.freeTrial() != null) {
            this.freeTrial().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("freeTrial", (JsonSerializable)this.freeTrial);
        return jsonWriter.writeEndObject();
    }

    public static QuotaProperties fromJson(JsonReader jsonReader) throws IOException {
        return (QuotaProperties)jsonReader.readObject(reader -> {
            QuotaProperties deserializedQuotaProperties = new QuotaProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("freeTrial".equals(fieldName)) {
                    deserializedQuotaProperties.freeTrial = FreeTrialProperties.fromJson(reader);
                    continue;
                }
                if ("offeringType".equals(fieldName)) {
                    deserializedQuotaProperties.offeringType = OfferingType.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedQuotaProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQuotaProperties;
        });
    }
}

