/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwrighttesting.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.playwrighttesting.models.EnablementStatus;
import java.io.IOException;

public final class AccountUpdateProperties
implements JsonSerializable<AccountUpdateProperties> {
    private EnablementStatus regionalAffinity;
    private EnablementStatus scalableExecution;
    private EnablementStatus reporting;
    private EnablementStatus localAuth;

    public EnablementStatus regionalAffinity() {
        return this.regionalAffinity;
    }

    public AccountUpdateProperties withRegionalAffinity(EnablementStatus regionalAffinity) {
        this.regionalAffinity = regionalAffinity;
        return this;
    }

    public EnablementStatus scalableExecution() {
        return this.scalableExecution;
    }

    public AccountUpdateProperties withScalableExecution(EnablementStatus scalableExecution) {
        this.scalableExecution = scalableExecution;
        return this;
    }

    public EnablementStatus reporting() {
        return this.reporting;
    }

    public AccountUpdateProperties withReporting(EnablementStatus reporting) {
        this.reporting = reporting;
        return this;
    }

    public EnablementStatus localAuth() {
        return this.localAuth;
    }

    public AccountUpdateProperties withLocalAuth(EnablementStatus localAuth) {
        this.localAuth = localAuth;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("regionalAffinity", this.regionalAffinity == null ? null : this.regionalAffinity.toString());
        jsonWriter.writeStringField("scalableExecution", this.scalableExecution == null ? null : this.scalableExecution.toString());
        jsonWriter.writeStringField("reporting", this.reporting == null ? null : this.reporting.toString());
        jsonWriter.writeStringField("localAuth", this.localAuth == null ? null : this.localAuth.toString());
        return jsonWriter.writeEndObject();
    }

    public static AccountUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AccountUpdateProperties)jsonReader.readObject(reader -> {
            AccountUpdateProperties deserializedAccountUpdateProperties = new AccountUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("regionalAffinity".equals(fieldName)) {
                    deserializedAccountUpdateProperties.regionalAffinity = EnablementStatus.fromString(reader.getString());
                    continue;
                }
                if ("scalableExecution".equals(fieldName)) {
                    deserializedAccountUpdateProperties.scalableExecution = EnablementStatus.fromString(reader.getString());
                    continue;
                }
                if ("reporting".equals(fieldName)) {
                    deserializedAccountUpdateProperties.reporting = EnablementStatus.fromString(reader.getString());
                    continue;
                }
                if ("localAuth".equals(fieldName)) {
                    deserializedAccountUpdateProperties.localAuth = EnablementStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccountUpdateProperties;
        });
    }
}

