/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceCommandSpecification;
import java.io.IOException;
import java.util.List;

public final class StorageApplianceRunReadCommandsParameters
implements JsonSerializable<StorageApplianceRunReadCommandsParameters> {
    private List<StorageApplianceCommandSpecification> commands;
    private long limitTimeSeconds;
    private static final ClientLogger LOGGER = new ClientLogger(StorageApplianceRunReadCommandsParameters.class);

    public List<StorageApplianceCommandSpecification> commands() {
        return this.commands;
    }

    public StorageApplianceRunReadCommandsParameters withCommands(List<StorageApplianceCommandSpecification> commands) {
        this.commands = commands;
        return this;
    }

    public long limitTimeSeconds() {
        return this.limitTimeSeconds;
    }

    public StorageApplianceRunReadCommandsParameters withLimitTimeSeconds(long limitTimeSeconds) {
        this.limitTimeSeconds = limitTimeSeconds;
        return this;
    }

    public void validate() {
        if (this.commands() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property commands in model StorageApplianceRunReadCommandsParameters"));
        }
        this.commands().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("commands", this.commands, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeLongField("limitTimeSeconds", this.limitTimeSeconds);
        return jsonWriter.writeEndObject();
    }

    public static StorageApplianceRunReadCommandsParameters fromJson(JsonReader jsonReader) throws IOException {
        return (StorageApplianceRunReadCommandsParameters)jsonReader.readObject(reader -> {
            StorageApplianceRunReadCommandsParameters deserializedStorageApplianceRunReadCommandsParameters = new StorageApplianceRunReadCommandsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("commands".equals(fieldName)) {
                    List commands;
                    deserializedStorageApplianceRunReadCommandsParameters.commands = commands = reader.readArray(reader1 -> StorageApplianceCommandSpecification.fromJson(reader1));
                    continue;
                }
                if ("limitTimeSeconds".equals(fieldName)) {
                    deserializedStorageApplianceRunReadCommandsParameters.limitTimeSeconds = reader.getLong();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageApplianceRunReadCommandsParameters;
        });
    }
}

