/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.RackSkuInner;
import java.io.IOException;
import java.util.List;

public final class RackSkuList
implements JsonSerializable<RackSkuList> {
    private String nextLink;
    private List<RackSkuInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public RackSkuList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<RackSkuInner> value() {
        return this.value;
    }

    public RackSkuList withValue(List<RackSkuInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RackSkuList fromJson(JsonReader jsonReader) throws IOException {
        return (RackSkuList)jsonReader.readObject(reader -> {
            RackSkuList deserializedRackSkuList = new RackSkuList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedRackSkuList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedRackSkuList.value = value = reader.readArray(reader1 -> RackSkuInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRackSkuList;
        });
    }
}

