/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.L3NetworkInner;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HybridAksIpamEnabled;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.IpAllocationType;
import com.azure.resourcemanager.networkcloud.models.L3NetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.L3NetworkProvisioningState;
import java.util.List;
import java.util.Map;

public interface L3Network {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public List<String> associatedResourceIds();

    public String clusterId();

    public L3NetworkDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public List<String> hybridAksClustersAssociatedIds();

    public HybridAksIpamEnabled hybridAksIpamEnabled();

    public HybridAksPluginType hybridAksPluginType();

    public String interfaceName();

    public IpAllocationType ipAllocationType();

    public String ipv4ConnectedPrefix();

    public String ipv6ConnectedPrefix();

    public String l3IsolationDomainId();

    public L3NetworkProvisioningState provisioningState();

    public List<String> virtualMachinesAssociatedIds();

    public long vlan();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public L3NetworkInner innerModel();

    public Update update();

    public L3Network refresh();

    public L3Network refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfNoneMatch {
            public Update withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIfMatch,
    UpdateStages.WithIfNoneMatch {
        public L3Network apply();

        public L3Network apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithIpv6ConnectedPrefix {
            public WithCreate withIpv6ConnectedPrefix(String var1);
        }

        public static interface WithIpv4ConnectedPrefix {
            public WithCreate withIpv4ConnectedPrefix(String var1);
        }

        public static interface WithIpAllocationType {
            public WithCreate withIpAllocationType(IpAllocationType var1);
        }

        public static interface WithInterfaceName {
            public WithCreate withInterfaceName(String var1);
        }

        public static interface WithHybridAksPluginType {
            public WithCreate withHybridAksPluginType(HybridAksPluginType var1);
        }

        public static interface WithHybridAksIpamEnabled {
            public WithCreate withHybridAksIpamEnabled(HybridAksIpamEnabled var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithHybridAksIpamEnabled,
        WithHybridAksPluginType,
        WithInterfaceName,
        WithIpAllocationType,
        WithIpv4ConnectedPrefix,
        WithIpv6ConnectedPrefix,
        WithIfMatch,
        WithIfNoneMatch {
            public L3Network create();

            public L3Network create(Context var1);
        }

        public static interface WithVlan {
            public WithCreate withVlan(long var1);
        }

        public static interface WithL3IsolationDomainId {
            public WithVlan withL3IsolationDomainId(String var1);
        }

        public static interface WithExtendedLocation {
            public WithL3IsolationDomainId withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithResourceGroup {
            public WithExtendedLocation withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithL3IsolationDomainId,
    DefinitionStages.WithVlan,
    DefinitionStages.WithCreate {
    }
}

