/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterPatchProperties;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfigurationPatch;
import com.azure.resourcemanager.networkcloud.models.ControlPlaneNodePatchConfiguration;
import java.io.IOException;
import java.util.Map;

public final class KubernetesClusterPatchParameters
implements JsonSerializable<KubernetesClusterPatchParameters> {
    private KubernetesClusterPatchProperties innerProperties;
    private Map<String, String> tags;

    private KubernetesClusterPatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public KubernetesClusterPatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public AdministratorConfigurationPatch administratorConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorConfiguration();
    }

    public KubernetesClusterPatchParameters withAdministratorConfiguration(AdministratorConfigurationPatch administratorConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterPatchProperties();
        }
        this.innerProperties().withAdministratorConfiguration(administratorConfiguration);
        return this;
    }

    public ControlPlaneNodePatchConfiguration controlPlaneNodeConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().controlPlaneNodeConfiguration();
    }

    public KubernetesClusterPatchParameters withControlPlaneNodeConfiguration(ControlPlaneNodePatchConfiguration controlPlaneNodeConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterPatchProperties();
        }
        this.innerProperties().withControlPlaneNodeConfiguration(controlPlaneNodeConfiguration);
        return this;
    }

    public String kubernetesVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().kubernetesVersion();
    }

    public KubernetesClusterPatchParameters withKubernetesVersion(String kubernetesVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterPatchProperties();
        }
        this.innerProperties().withKubernetesVersion(kubernetesVersion);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterPatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterPatchParameters)jsonReader.readObject(reader -> {
            KubernetesClusterPatchParameters deserializedKubernetesClusterPatchParameters = new KubernetesClusterPatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedKubernetesClusterPatchParameters.innerProperties = KubernetesClusterPatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedKubernetesClusterPatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterPatchParameters;
        });
    }
}

