/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterFeatureInner;
import java.io.IOException;
import java.util.List;

public final class KubernetesClusterFeatureList
implements JsonSerializable<KubernetesClusterFeatureList> {
    private String nextLink;
    private List<KubernetesClusterFeatureInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public KubernetesClusterFeatureList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<KubernetesClusterFeatureInner> value() {
        return this.value;
    }

    public KubernetesClusterFeatureList withValue(List<KubernetesClusterFeatureInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterFeatureList fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterFeatureList)jsonReader.readObject(reader -> {
            KubernetesClusterFeatureList deserializedKubernetesClusterFeatureList = new KubernetesClusterFeatureList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedKubernetesClusterFeatureList.value = value = reader.readArray(reader1 -> KubernetesClusterFeatureInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterFeatureList;
        });
    }
}

