/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.CommandOutputType;
import com.azure.resourcemanager.networkcloud.models.IdentitySelector;
import java.io.IOException;

public final class CommandOutputOverride
implements JsonSerializable<CommandOutputOverride> {
    private IdentitySelector associatedIdentity;
    private CommandOutputType commandOutputType;
    private String containerUrl;

    public IdentitySelector associatedIdentity() {
        return this.associatedIdentity;
    }

    public CommandOutputOverride withAssociatedIdentity(IdentitySelector associatedIdentity) {
        this.associatedIdentity = associatedIdentity;
        return this;
    }

    public CommandOutputType commandOutputType() {
        return this.commandOutputType;
    }

    public CommandOutputOverride withCommandOutputType(CommandOutputType commandOutputType) {
        this.commandOutputType = commandOutputType;
        return this;
    }

    public String containerUrl() {
        return this.containerUrl;
    }

    public CommandOutputOverride withContainerUrl(String containerUrl) {
        this.containerUrl = containerUrl;
        return this;
    }

    public void validate() {
        if (this.associatedIdentity() != null) {
            this.associatedIdentity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("associatedIdentity", (JsonSerializable)this.associatedIdentity);
        jsonWriter.writeStringField("commandOutputType", this.commandOutputType == null ? null : this.commandOutputType.toString());
        jsonWriter.writeStringField("containerUrl", this.containerUrl);
        return jsonWriter.writeEndObject();
    }

    public static CommandOutputOverride fromJson(JsonReader jsonReader) throws IOException {
        return (CommandOutputOverride)jsonReader.readObject(reader -> {
            CommandOutputOverride deserializedCommandOutputOverride = new CommandOutputOverride();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("associatedIdentity".equals(fieldName)) {
                    deserializedCommandOutputOverride.associatedIdentity = IdentitySelector.fromJson(reader);
                    continue;
                }
                if ("commandOutputType".equals(fieldName)) {
                    deserializedCommandOutputOverride.commandOutputType = CommandOutputType.fromString(reader.getString());
                    continue;
                }
                if ("containerUrl".equals(fieldName)) {
                    deserializedCommandOutputOverride.containerUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommandOutputOverride;
        });
    }
}

