/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterMetricsConfigurationInner;
import java.io.IOException;
import java.util.List;

public final class ClusterMetricsConfigurationList
implements JsonSerializable<ClusterMetricsConfigurationList> {
    private String nextLink;
    private List<ClusterMetricsConfigurationInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public ClusterMetricsConfigurationList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<ClusterMetricsConfigurationInner> value() {
        return this.value;
    }

    public ClusterMetricsConfigurationList withValue(List<ClusterMetricsConfigurationInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ClusterMetricsConfigurationList fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterMetricsConfigurationList)jsonReader.readObject(reader -> {
            ClusterMetricsConfigurationList deserializedClusterMetricsConfigurationList = new ClusterMetricsConfigurationList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedClusterMetricsConfigurationList.value = value = reader.readArray(reader1 -> ClusterMetricsConfigurationInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterMetricsConfigurationList;
        });
    }
}

