/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BareMetalMachineRunCommandParameters
implements JsonSerializable<BareMetalMachineRunCommandParameters> {
    private List<String> arguments;
    private long limitTimeSeconds;
    private String script;
    private static final ClientLogger LOGGER = new ClientLogger(BareMetalMachineRunCommandParameters.class);

    public List<String> arguments() {
        return this.arguments;
    }

    public BareMetalMachineRunCommandParameters withArguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public long limitTimeSeconds() {
        return this.limitTimeSeconds;
    }

    public BareMetalMachineRunCommandParameters withLimitTimeSeconds(long limitTimeSeconds) {
        this.limitTimeSeconds = limitTimeSeconds;
        return this;
    }

    public String script() {
        return this.script;
    }

    public BareMetalMachineRunCommandParameters withScript(String script) {
        this.script = script;
        return this;
    }

    public void validate() {
        if (this.script() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property script in model BareMetalMachineRunCommandParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("limitTimeSeconds", this.limitTimeSeconds);
        jsonWriter.writeStringField("script", this.script);
        jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachineRunCommandParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachineRunCommandParameters)jsonReader.readObject(reader -> {
            BareMetalMachineRunCommandParameters deserializedBareMetalMachineRunCommandParameters = new BareMetalMachineRunCommandParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("limitTimeSeconds".equals(fieldName)) {
                    deserializedBareMetalMachineRunCommandParameters.limitTimeSeconds = reader.getLong();
                    continue;
                }
                if ("script".equals(fieldName)) {
                    deserializedBareMetalMachineRunCommandParameters.script = reader.getString();
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    List arguments;
                    deserializedBareMetalMachineRunCommandParameters.arguments = arguments = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachineRunCommandParameters;
        });
    }
}

