/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.VolumesClient;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.fluent.models.VolumeInner;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.implementation.VolumeImpl;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.Volume;
import com.azure.resourcemanager.networkcloud.models.Volumes;

public final class VolumesImpl
implements Volumes {
    private static final ClientLogger LOGGER = new ClientLogger(VolumesImpl.class);
    private final VolumesClient innerClient;
    private final NetworkCloudManager serviceManager;

    public VolumesImpl(VolumesClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Volume> list() {
        PagedIterable<VolumeInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeImpl((VolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Volume> list(Integer top, String skipToken, Context context) {
        PagedIterable<VolumeInner> inner = this.serviceClient().list(top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeImpl((VolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Volume> listByResourceGroup(String resourceGroupName) {
        PagedIterable<VolumeInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeImpl((VolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Volume> listByResourceGroup(String resourceGroupName, Integer top, String skipToken, Context context) {
        PagedIterable<VolumeInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VolumeImpl((VolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Volume> getByResourceGroupWithResponse(String resourceGroupName, String volumeName, Context context) {
        Response<VolumeInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, volumeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VolumeImpl((VolumeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Volume getByResourceGroup(String resourceGroupName, String volumeName) {
        VolumeInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, volumeName);
        if (inner != null) {
            return new VolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String volumeName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, volumeName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String volumeName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, volumeName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Volume getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        return (Volume)this.getByResourceGroupWithResponse(resourceGroupName, volumeName, Context.NONE).getValue();
    }

    @Override
    public Response<Volume> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, volumeName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, volumeName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        return this.delete(resourceGroupName, volumeName, ifMatch, ifNoneMatch, context);
    }

    private VolumesClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public VolumeImpl define(String name) {
        return new VolumeImpl(name, this.manager());
    }
}

