/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.StorageAppliancesClient;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.fluent.models.StorageApplianceInner;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.implementation.StorageApplianceImpl;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.StorageAppliance;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceEnableRemoteVendorManagementParameters;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceRunReadCommandsParameters;
import com.azure.resourcemanager.networkcloud.models.StorageAppliances;

public final class StorageAppliancesImpl
implements StorageAppliances {
    private static final ClientLogger LOGGER = new ClientLogger(StorageAppliancesImpl.class);
    private final StorageAppliancesClient innerClient;
    private final NetworkCloudManager serviceManager;

    public StorageAppliancesImpl(StorageAppliancesClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<StorageAppliance> list() {
        PagedIterable<StorageApplianceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageApplianceImpl((StorageApplianceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageAppliance> list(Integer top, String skipToken, Context context) {
        PagedIterable<StorageApplianceInner> inner = this.serviceClient().list(top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageApplianceImpl((StorageApplianceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageAppliance> listByResourceGroup(String resourceGroupName) {
        PagedIterable<StorageApplianceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageApplianceImpl((StorageApplianceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<StorageAppliance> listByResourceGroup(String resourceGroupName, Integer top, String skipToken, Context context) {
        PagedIterable<StorageApplianceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StorageApplianceImpl((StorageApplianceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<StorageAppliance> getByResourceGroupWithResponse(String resourceGroupName, String storageApplianceName, Context context) {
        Response<StorageApplianceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, storageApplianceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new StorageApplianceImpl((StorageApplianceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public StorageAppliance getByResourceGroup(String resourceGroupName, String storageApplianceName) {
        StorageApplianceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, storageApplianceName);
        if (inner != null) {
            return new StorageApplianceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String storageApplianceName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, storageApplianceName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String storageApplianceName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, storageApplianceName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult disableRemoteVendorManagement(String resourceGroupName, String storageApplianceName) {
        OperationStatusResultInner inner = this.serviceClient().disableRemoteVendorManagement(resourceGroupName, storageApplianceName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult disableRemoteVendorManagement(String resourceGroupName, String storageApplianceName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().disableRemoteVendorManagement(resourceGroupName, storageApplianceName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult enableRemoteVendorManagement(String resourceGroupName, String storageApplianceName) {
        OperationStatusResultInner inner = this.serviceClient().enableRemoteVendorManagement(resourceGroupName, storageApplianceName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult enableRemoteVendorManagement(String resourceGroupName, String storageApplianceName, StorageApplianceEnableRemoteVendorManagementParameters storageApplianceEnableRemoteVendorManagementParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().enableRemoteVendorManagement(resourceGroupName, storageApplianceName, storageApplianceEnableRemoteVendorManagementParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult runReadCommands(String resourceGroupName, String storageApplianceName, StorageApplianceRunReadCommandsParameters storageApplianceRunReadCommandsParameters) {
        OperationStatusResultInner inner = this.serviceClient().runReadCommands(resourceGroupName, storageApplianceName, storageApplianceRunReadCommandsParameters);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult runReadCommands(String resourceGroupName, String storageApplianceName, StorageApplianceRunReadCommandsParameters storageApplianceRunReadCommandsParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().runReadCommands(resourceGroupName, storageApplianceName, storageApplianceRunReadCommandsParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public StorageAppliance getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageApplianceName = ResourceManagerUtils.getValueFromIdByName(id, "storageAppliances");
        if (storageApplianceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageAppliances'.", id)));
        }
        return (StorageAppliance)this.getByResourceGroupWithResponse(resourceGroupName, storageApplianceName, Context.NONE).getValue();
    }

    @Override
    public Response<StorageAppliance> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageApplianceName = ResourceManagerUtils.getValueFromIdByName(id, "storageAppliances");
        if (storageApplianceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageAppliances'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, storageApplianceName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageApplianceName = ResourceManagerUtils.getValueFromIdByName(id, "storageAppliances");
        if (storageApplianceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageAppliances'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, storageApplianceName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String storageApplianceName = ResourceManagerUtils.getValueFromIdByName(id, "storageAppliances");
        if (storageApplianceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'storageAppliances'.", id)));
        }
        return this.delete(resourceGroupName, storageApplianceName, ifMatch, ifNoneMatch, context);
    }

    private StorageAppliancesClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public StorageApplianceImpl define(String name) {
        return new StorageApplianceImpl(name, this.manager());
    }
}

