/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.networkcloud.fluent.AgentPoolsClient;
import com.azure.resourcemanager.networkcloud.fluent.BareMetalMachineKeySetsClient;
import com.azure.resourcemanager.networkcloud.fluent.BareMetalMachinesClient;
import com.azure.resourcemanager.networkcloud.fluent.BmcKeySetsClient;
import com.azure.resourcemanager.networkcloud.fluent.CloudServicesNetworksClient;
import com.azure.resourcemanager.networkcloud.fluent.ClusterManagersClient;
import com.azure.resourcemanager.networkcloud.fluent.ClustersClient;
import com.azure.resourcemanager.networkcloud.fluent.ConsolesClient;
import com.azure.resourcemanager.networkcloud.fluent.KubernetesClusterFeaturesClient;
import com.azure.resourcemanager.networkcloud.fluent.KubernetesClustersClient;
import com.azure.resourcemanager.networkcloud.fluent.L2NetworksClient;
import com.azure.resourcemanager.networkcloud.fluent.L3NetworksClient;
import com.azure.resourcemanager.networkcloud.fluent.MetricsConfigurationsClient;
import com.azure.resourcemanager.networkcloud.fluent.NetworkCloud;
import com.azure.resourcemanager.networkcloud.fluent.OperationsClient;
import com.azure.resourcemanager.networkcloud.fluent.RackSkusClient;
import com.azure.resourcemanager.networkcloud.fluent.RacksClient;
import com.azure.resourcemanager.networkcloud.fluent.StorageAppliancesClient;
import com.azure.resourcemanager.networkcloud.fluent.TrunkedNetworksClient;
import com.azure.resourcemanager.networkcloud.fluent.VirtualMachinesClient;
import com.azure.resourcemanager.networkcloud.fluent.VolumesClient;
import com.azure.resourcemanager.networkcloud.implementation.AgentPoolsClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.BareMetalMachineKeySetsClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.BareMetalMachinesClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.BmcKeySetsClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.CloudServicesNetworksClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.ClusterManagersClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.ClustersClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.ConsolesClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.KubernetesClusterFeaturesClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.KubernetesClustersClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.L2NetworksClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.L3NetworksClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.MetricsConfigurationsClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudBuilder;
import com.azure.resourcemanager.networkcloud.implementation.OperationsClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.RackSkusClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.RacksClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.StorageAppliancesClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.TrunkedNetworksClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.VirtualMachinesClientImpl;
import com.azure.resourcemanager.networkcloud.implementation.VolumesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=NetworkCloudBuilder.class)
public final class NetworkCloudImpl
implements NetworkCloud {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final BareMetalMachinesClient bareMetalMachines;
    private final CloudServicesNetworksClient cloudServicesNetworks;
    private final ClusterManagersClient clusterManagers;
    private final ClustersClient clusters;
    private final KubernetesClustersClient kubernetesClusters;
    private final L2NetworksClient l2Networks;
    private final L3NetworksClient l3Networks;
    private final RackSkusClient rackSkus;
    private final RacksClient racks;
    private final StorageAppliancesClient storageAppliances;
    private final TrunkedNetworksClient trunkedNetworks;
    private final VirtualMachinesClient virtualMachines;
    private final VolumesClient volumes;
    private final BareMetalMachineKeySetsClient bareMetalMachineKeySets;
    private final BmcKeySetsClient bmcKeySets;
    private final MetricsConfigurationsClient metricsConfigurations;
    private final AgentPoolsClient agentPools;
    private final KubernetesClusterFeaturesClient kubernetesClusterFeatures;
    private final ConsolesClient consoles;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkCloudImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public BareMetalMachinesClient getBareMetalMachines() {
        return this.bareMetalMachines;
    }

    @Override
    public CloudServicesNetworksClient getCloudServicesNetworks() {
        return this.cloudServicesNetworks;
    }

    @Override
    public ClusterManagersClient getClusterManagers() {
        return this.clusterManagers;
    }

    @Override
    public ClustersClient getClusters() {
        return this.clusters;
    }

    @Override
    public KubernetesClustersClient getKubernetesClusters() {
        return this.kubernetesClusters;
    }

    @Override
    public L2NetworksClient getL2Networks() {
        return this.l2Networks;
    }

    @Override
    public L3NetworksClient getL3Networks() {
        return this.l3Networks;
    }

    @Override
    public RackSkusClient getRackSkus() {
        return this.rackSkus;
    }

    @Override
    public RacksClient getRacks() {
        return this.racks;
    }

    @Override
    public StorageAppliancesClient getStorageAppliances() {
        return this.storageAppliances;
    }

    @Override
    public TrunkedNetworksClient getTrunkedNetworks() {
        return this.trunkedNetworks;
    }

    @Override
    public VirtualMachinesClient getVirtualMachines() {
        return this.virtualMachines;
    }

    @Override
    public VolumesClient getVolumes() {
        return this.volumes;
    }

    @Override
    public BareMetalMachineKeySetsClient getBareMetalMachineKeySets() {
        return this.bareMetalMachineKeySets;
    }

    @Override
    public BmcKeySetsClient getBmcKeySets() {
        return this.bmcKeySets;
    }

    @Override
    public MetricsConfigurationsClient getMetricsConfigurations() {
        return this.metricsConfigurations;
    }

    @Override
    public AgentPoolsClient getAgentPools() {
        return this.agentPools;
    }

    @Override
    public KubernetesClusterFeaturesClient getKubernetesClusterFeatures() {
        return this.kubernetesClusterFeatures;
    }

    @Override
    public ConsolesClient getConsoles() {
        return this.consoles;
    }

    NetworkCloudImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2025-07-01-preview";
        this.operations = new OperationsClientImpl(this);
        this.bareMetalMachines = new BareMetalMachinesClientImpl(this);
        this.cloudServicesNetworks = new CloudServicesNetworksClientImpl(this);
        this.clusterManagers = new ClusterManagersClientImpl(this);
        this.clusters = new ClustersClientImpl(this);
        this.kubernetesClusters = new KubernetesClustersClientImpl(this);
        this.l2Networks = new L2NetworksClientImpl(this);
        this.l3Networks = new L3NetworksClientImpl(this);
        this.rackSkus = new RackSkusClientImpl(this);
        this.racks = new RacksClientImpl(this);
        this.storageAppliances = new StorageAppliancesClientImpl(this);
        this.trunkedNetworks = new TrunkedNetworksClientImpl(this);
        this.virtualMachines = new VirtualMachinesClientImpl(this);
        this.volumes = new VolumesClientImpl(this);
        this.bareMetalMachineKeySets = new BareMetalMachineKeySetsClientImpl(this);
        this.bmcKeySets = new BmcKeySetsClientImpl(this);
        this.metricsConfigurations = new MetricsConfigurationsClientImpl(this);
        this.agentPools = new AgentPoolsClientImpl(this);
        this.kubernetesClusterFeatures = new KubernetesClusterFeaturesClientImpl(this);
        this.consoles = new ConsolesClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

