/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ImageRepositoryCredentials;
import com.azure.resourcemanager.networkcloud.models.NetworkAttachment;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import com.azure.resourcemanager.networkcloud.models.StorageProfile;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineBootMethod;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineDeviceModelType;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineIsolateEmulatorThread;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePlacementHint;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePowerState;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineProvisioningState;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineVirtioInterfaceType;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineProperties
implements JsonSerializable<VirtualMachineProperties> {
    private String adminUsername;
    private String availabilityZone;
    private String bareMetalMachineId;
    private VirtualMachineBootMethod bootMethod;
    private NetworkAttachment cloudServicesNetworkAttachment;
    private String clusterId;
    private ExtendedLocation consoleExtendedLocation;
    private long cpuCores;
    private VirtualMachineDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private VirtualMachineIsolateEmulatorThread isolateEmulatorThread;
    private long memorySizeGB;
    private List<NetworkAttachment> networkAttachments;
    private String networkData;
    private String networkDataContent;
    private List<VirtualMachinePlacementHint> placementHints;
    private VirtualMachinePowerState powerState;
    private VirtualMachineProvisioningState provisioningState;
    private List<SshPublicKey> sshPublicKeys;
    private StorageProfile storageProfile;
    private String userData;
    private String userDataContent;
    private VirtualMachineVirtioInterfaceType virtioInterface;
    private VirtualMachineDeviceModelType vmDeviceModel;
    private String vmImage;
    private ImageRepositoryCredentials vmImageRepositoryCredentials;
    private List<String> volumes;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineProperties.class);

    public String adminUsername() {
        return this.adminUsername;
    }

    public VirtualMachineProperties withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return this;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String bareMetalMachineId() {
        return this.bareMetalMachineId;
    }

    public VirtualMachineBootMethod bootMethod() {
        return this.bootMethod;
    }

    public VirtualMachineProperties withBootMethod(VirtualMachineBootMethod bootMethod) {
        this.bootMethod = bootMethod;
        return this;
    }

    public NetworkAttachment cloudServicesNetworkAttachment() {
        return this.cloudServicesNetworkAttachment;
    }

    public VirtualMachineProperties withCloudServicesNetworkAttachment(NetworkAttachment cloudServicesNetworkAttachment) {
        this.cloudServicesNetworkAttachment = cloudServicesNetworkAttachment;
        return this;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public ExtendedLocation consoleExtendedLocation() {
        return this.consoleExtendedLocation;
    }

    public VirtualMachineProperties withConsoleExtendedLocation(ExtendedLocation consoleExtendedLocation) {
        this.consoleExtendedLocation = consoleExtendedLocation;
        return this;
    }

    public long cpuCores() {
        return this.cpuCores;
    }

    public VirtualMachineProperties withCpuCores(long cpuCores) {
        this.cpuCores = cpuCores;
        return this;
    }

    public VirtualMachineDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public VirtualMachineIsolateEmulatorThread isolateEmulatorThread() {
        return this.isolateEmulatorThread;
    }

    public VirtualMachineProperties withIsolateEmulatorThread(VirtualMachineIsolateEmulatorThread isolateEmulatorThread) {
        this.isolateEmulatorThread = isolateEmulatorThread;
        return this;
    }

    public long memorySizeGB() {
        return this.memorySizeGB;
    }

    public VirtualMachineProperties withMemorySizeGB(long memorySizeGB) {
        this.memorySizeGB = memorySizeGB;
        return this;
    }

    public List<NetworkAttachment> networkAttachments() {
        return this.networkAttachments;
    }

    public VirtualMachineProperties withNetworkAttachments(List<NetworkAttachment> networkAttachments) {
        this.networkAttachments = networkAttachments;
        return this;
    }

    public String networkData() {
        return this.networkData;
    }

    public VirtualMachineProperties withNetworkData(String networkData) {
        this.networkData = networkData;
        return this;
    }

    public String networkDataContent() {
        return this.networkDataContent;
    }

    public VirtualMachineProperties withNetworkDataContent(String networkDataContent) {
        this.networkDataContent = networkDataContent;
        return this;
    }

    public List<VirtualMachinePlacementHint> placementHints() {
        return this.placementHints;
    }

    public VirtualMachineProperties withPlacementHints(List<VirtualMachinePlacementHint> placementHints) {
        this.placementHints = placementHints;
        return this;
    }

    public VirtualMachinePowerState powerState() {
        return this.powerState;
    }

    public VirtualMachineProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<SshPublicKey> sshPublicKeys() {
        return this.sshPublicKeys;
    }

    public VirtualMachineProperties withSshPublicKeys(List<SshPublicKey> sshPublicKeys) {
        this.sshPublicKeys = sshPublicKeys;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public VirtualMachineProperties withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public String userData() {
        return this.userData;
    }

    public VirtualMachineProperties withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public String userDataContent() {
        return this.userDataContent;
    }

    public VirtualMachineProperties withUserDataContent(String userDataContent) {
        this.userDataContent = userDataContent;
        return this;
    }

    public VirtualMachineVirtioInterfaceType virtioInterface() {
        return this.virtioInterface;
    }

    public VirtualMachineProperties withVirtioInterface(VirtualMachineVirtioInterfaceType virtioInterface) {
        this.virtioInterface = virtioInterface;
        return this;
    }

    public VirtualMachineDeviceModelType vmDeviceModel() {
        return this.vmDeviceModel;
    }

    public VirtualMachineProperties withVmDeviceModel(VirtualMachineDeviceModelType vmDeviceModel) {
        this.vmDeviceModel = vmDeviceModel;
        return this;
    }

    public String vmImage() {
        return this.vmImage;
    }

    public VirtualMachineProperties withVmImage(String vmImage) {
        this.vmImage = vmImage;
        return this;
    }

    public ImageRepositoryCredentials vmImageRepositoryCredentials() {
        return this.vmImageRepositoryCredentials;
    }

    public VirtualMachineProperties withVmImageRepositoryCredentials(ImageRepositoryCredentials vmImageRepositoryCredentials) {
        this.vmImageRepositoryCredentials = vmImageRepositoryCredentials;
        return this;
    }

    public List<String> volumes() {
        return this.volumes;
    }

    public void validate() {
        if (this.adminUsername() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property adminUsername in model VirtualMachineProperties"));
        }
        if (this.cloudServicesNetworkAttachment() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property cloudServicesNetworkAttachment in model VirtualMachineProperties"));
        }
        this.cloudServicesNetworkAttachment().validate();
        if (this.consoleExtendedLocation() != null) {
            this.consoleExtendedLocation().validate();
        }
        if (this.networkAttachments() != null) {
            this.networkAttachments().forEach(e -> e.validate());
        }
        if (this.placementHints() != null) {
            this.placementHints().forEach(e -> e.validate());
        }
        if (this.sshPublicKeys() != null) {
            this.sshPublicKeys().forEach(e -> e.validate());
        }
        if (this.storageProfile() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageProfile in model VirtualMachineProperties"));
        }
        this.storageProfile().validate();
        if (this.vmImage() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vmImage in model VirtualMachineProperties"));
        }
        if (this.vmImageRepositoryCredentials() != null) {
            this.vmImageRepositoryCredentials().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("adminUsername", this.adminUsername);
        jsonWriter.writeJsonField("cloudServicesNetworkAttachment", (JsonSerializable)this.cloudServicesNetworkAttachment);
        jsonWriter.writeLongField("cpuCores", this.cpuCores);
        jsonWriter.writeLongField("memorySizeGB", this.memorySizeGB);
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeStringField("vmImage", this.vmImage);
        jsonWriter.writeStringField("bootMethod", this.bootMethod == null ? null : this.bootMethod.toString());
        jsonWriter.writeJsonField("consoleExtendedLocation", (JsonSerializable)this.consoleExtendedLocation);
        jsonWriter.writeStringField("isolateEmulatorThread", this.isolateEmulatorThread == null ? null : this.isolateEmulatorThread.toString());
        jsonWriter.writeArrayField("networkAttachments", this.networkAttachments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("networkData", this.networkData);
        jsonWriter.writeStringField("networkDataContent", this.networkDataContent);
        jsonWriter.writeArrayField("placementHints", this.placementHints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sshPublicKeys", this.sshPublicKeys, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("userData", this.userData);
        jsonWriter.writeStringField("userDataContent", this.userDataContent);
        jsonWriter.writeStringField("virtioInterface", this.virtioInterface == null ? null : this.virtioInterface.toString());
        jsonWriter.writeStringField("vmDeviceModel", this.vmDeviceModel == null ? null : this.vmDeviceModel.toString());
        jsonWriter.writeJsonField("vmImageRepositoryCredentials", (JsonSerializable)this.vmImageRepositoryCredentials);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineProperties)jsonReader.readObject(reader -> {
            VirtualMachineProperties deserializedVirtualMachineProperties = new VirtualMachineProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("adminUsername".equals(fieldName)) {
                    deserializedVirtualMachineProperties.adminUsername = reader.getString();
                    continue;
                }
                if ("cloudServicesNetworkAttachment".equals(fieldName)) {
                    deserializedVirtualMachineProperties.cloudServicesNetworkAttachment = NetworkAttachment.fromJson(reader);
                    continue;
                }
                if ("cpuCores".equals(fieldName)) {
                    deserializedVirtualMachineProperties.cpuCores = reader.getLong();
                    continue;
                }
                if ("memorySizeGB".equals(fieldName)) {
                    deserializedVirtualMachineProperties.memorySizeGB = reader.getLong();
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedVirtualMachineProperties.storageProfile = StorageProfile.fromJson(reader);
                    continue;
                }
                if ("vmImage".equals(fieldName)) {
                    deserializedVirtualMachineProperties.vmImage = reader.getString();
                    continue;
                }
                if ("availabilityZone".equals(fieldName)) {
                    deserializedVirtualMachineProperties.availabilityZone = reader.getString();
                    continue;
                }
                if ("bareMetalMachineId".equals(fieldName)) {
                    deserializedVirtualMachineProperties.bareMetalMachineId = reader.getString();
                    continue;
                }
                if ("bootMethod".equals(fieldName)) {
                    deserializedVirtualMachineProperties.bootMethod = VirtualMachineBootMethod.fromString(reader.getString());
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedVirtualMachineProperties.clusterId = reader.getString();
                    continue;
                }
                if ("consoleExtendedLocation".equals(fieldName)) {
                    deserializedVirtualMachineProperties.consoleExtendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedVirtualMachineProperties.detailedStatus = VirtualMachineDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedVirtualMachineProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("isolateEmulatorThread".equals(fieldName)) {
                    deserializedVirtualMachineProperties.isolateEmulatorThread = VirtualMachineIsolateEmulatorThread.fromString(reader.getString());
                    continue;
                }
                if ("networkAttachments".equals(fieldName)) {
                    List networkAttachments;
                    deserializedVirtualMachineProperties.networkAttachments = networkAttachments = reader.readArray(reader1 -> NetworkAttachment.fromJson(reader1));
                    continue;
                }
                if ("networkData".equals(fieldName)) {
                    deserializedVirtualMachineProperties.networkData = reader.getString();
                    continue;
                }
                if ("networkDataContent".equals(fieldName)) {
                    deserializedVirtualMachineProperties.networkDataContent = reader.getString();
                    continue;
                }
                if ("placementHints".equals(fieldName)) {
                    List placementHints;
                    deserializedVirtualMachineProperties.placementHints = placementHints = reader.readArray(reader1 -> VirtualMachinePlacementHint.fromJson(reader1));
                    continue;
                }
                if ("powerState".equals(fieldName)) {
                    deserializedVirtualMachineProperties.powerState = VirtualMachinePowerState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualMachineProperties.provisioningState = VirtualMachineProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("sshPublicKeys".equals(fieldName)) {
                    List sshPublicKeys;
                    deserializedVirtualMachineProperties.sshPublicKeys = sshPublicKeys = reader.readArray(reader1 -> SshPublicKey.fromJson(reader1));
                    continue;
                }
                if ("userData".equals(fieldName)) {
                    deserializedVirtualMachineProperties.userData = reader.getString();
                    continue;
                }
                if ("userDataContent".equals(fieldName)) {
                    deserializedVirtualMachineProperties.userDataContent = reader.getString();
                    continue;
                }
                if ("virtioInterface".equals(fieldName)) {
                    deserializedVirtualMachineProperties.virtioInterface = VirtualMachineVirtioInterfaceType.fromString(reader.getString());
                    continue;
                }
                if ("vmDeviceModel".equals(fieldName)) {
                    deserializedVirtualMachineProperties.vmDeviceModel = VirtualMachineDeviceModelType.fromString(reader.getString());
                    continue;
                }
                if ("vmImageRepositoryCredentials".equals(fieldName)) {
                    deserializedVirtualMachineProperties.vmImageRepositoryCredentials = ImageRepositoryCredentials.fromJson(reader);
                    continue;
                }
                if ("volumes".equals(fieldName)) {
                    List volumes;
                    deserializedVirtualMachineProperties.volumes = volumes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineProperties;
        });
    }
}

