/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.VirtualMachineProperties;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ImageRepositoryCredentials;
import com.azure.resourcemanager.networkcloud.models.ManagedServiceIdentity;
import com.azure.resourcemanager.networkcloud.models.NetworkAttachment;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import com.azure.resourcemanager.networkcloud.models.StorageProfile;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineBootMethod;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineDeviceModelType;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineIsolateEmulatorThread;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePlacementHint;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePowerState;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineProvisioningState;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineVirtioInterfaceType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualMachineInner
extends Resource {
    private String etag;
    private ExtendedLocation extendedLocation;
    private ManagedServiceIdentity identity;
    private VirtualMachineProperties innerProperties = new VirtualMachineProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineInner.class);

    public String etag() {
        return this.etag;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public VirtualMachineInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public VirtualMachineInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private VirtualMachineProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public VirtualMachineInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualMachineInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String adminUsername() {
        return this.innerProperties() == null ? null : this.innerProperties().adminUsername();
    }

    public VirtualMachineInner withAdminUsername(String adminUsername) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withAdminUsername(adminUsername);
        return this;
    }

    public String availabilityZone() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityZone();
    }

    public String bareMetalMachineId() {
        return this.innerProperties() == null ? null : this.innerProperties().bareMetalMachineId();
    }

    public VirtualMachineBootMethod bootMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().bootMethod();
    }

    public VirtualMachineInner withBootMethod(VirtualMachineBootMethod bootMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withBootMethod(bootMethod);
        return this;
    }

    public NetworkAttachment cloudServicesNetworkAttachment() {
        return this.innerProperties() == null ? null : this.innerProperties().cloudServicesNetworkAttachment();
    }

    public VirtualMachineInner withCloudServicesNetworkAttachment(NetworkAttachment cloudServicesNetworkAttachment) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withCloudServicesNetworkAttachment(cloudServicesNetworkAttachment);
        return this;
    }

    public String clusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterId();
    }

    public ExtendedLocation consoleExtendedLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().consoleExtendedLocation();
    }

    public VirtualMachineInner withConsoleExtendedLocation(ExtendedLocation consoleExtendedLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withConsoleExtendedLocation(consoleExtendedLocation);
        return this;
    }

    public long cpuCores() {
        return this.innerProperties() == null ? 0L : this.innerProperties().cpuCores();
    }

    public VirtualMachineInner withCpuCores(long cpuCores) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withCpuCores(cpuCores);
        return this;
    }

    public VirtualMachineDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public VirtualMachineIsolateEmulatorThread isolateEmulatorThread() {
        return this.innerProperties() == null ? null : this.innerProperties().isolateEmulatorThread();
    }

    public VirtualMachineInner withIsolateEmulatorThread(VirtualMachineIsolateEmulatorThread isolateEmulatorThread) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withIsolateEmulatorThread(isolateEmulatorThread);
        return this;
    }

    public long memorySizeGB() {
        return this.innerProperties() == null ? 0L : this.innerProperties().memorySizeGB();
    }

    public VirtualMachineInner withMemorySizeGB(long memorySizeGB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withMemorySizeGB(memorySizeGB);
        return this;
    }

    public List<NetworkAttachment> networkAttachments() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAttachments();
    }

    public VirtualMachineInner withNetworkAttachments(List<NetworkAttachment> networkAttachments) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withNetworkAttachments(networkAttachments);
        return this;
    }

    public String networkData() {
        return this.innerProperties() == null ? null : this.innerProperties().networkData();
    }

    public VirtualMachineInner withNetworkData(String networkData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withNetworkData(networkData);
        return this;
    }

    public String networkDataContent() {
        return this.innerProperties() == null ? null : this.innerProperties().networkDataContent();
    }

    public VirtualMachineInner withNetworkDataContent(String networkDataContent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withNetworkDataContent(networkDataContent);
        return this;
    }

    public List<VirtualMachinePlacementHint> placementHints() {
        return this.innerProperties() == null ? null : this.innerProperties().placementHints();
    }

    public VirtualMachineInner withPlacementHints(List<VirtualMachinePlacementHint> placementHints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withPlacementHints(placementHints);
        return this;
    }

    public VirtualMachinePowerState powerState() {
        return this.innerProperties() == null ? null : this.innerProperties().powerState();
    }

    public VirtualMachineProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<SshPublicKey> sshPublicKeys() {
        return this.innerProperties() == null ? null : this.innerProperties().sshPublicKeys();
    }

    public VirtualMachineInner withSshPublicKeys(List<SshPublicKey> sshPublicKeys) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withSshPublicKeys(sshPublicKeys);
        return this;
    }

    public StorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public VirtualMachineInner withStorageProfile(StorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public String userData() {
        return this.innerProperties() == null ? null : this.innerProperties().userData();
    }

    public VirtualMachineInner withUserData(String userData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withUserData(userData);
        return this;
    }

    public String userDataContent() {
        return this.innerProperties() == null ? null : this.innerProperties().userDataContent();
    }

    public VirtualMachineInner withUserDataContent(String userDataContent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withUserDataContent(userDataContent);
        return this;
    }

    public VirtualMachineVirtioInterfaceType virtioInterface() {
        return this.innerProperties() == null ? null : this.innerProperties().virtioInterface();
    }

    public VirtualMachineInner withVirtioInterface(VirtualMachineVirtioInterfaceType virtioInterface) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withVirtioInterface(virtioInterface);
        return this;
    }

    public VirtualMachineDeviceModelType vmDeviceModel() {
        return this.innerProperties() == null ? null : this.innerProperties().vmDeviceModel();
    }

    public VirtualMachineInner withVmDeviceModel(VirtualMachineDeviceModelType vmDeviceModel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withVmDeviceModel(vmDeviceModel);
        return this;
    }

    public String vmImage() {
        return this.innerProperties() == null ? null : this.innerProperties().vmImage();
    }

    public VirtualMachineInner withVmImage(String vmImage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withVmImage(vmImage);
        return this;
    }

    public ImageRepositoryCredentials vmImageRepositoryCredentials() {
        return this.innerProperties() == null ? null : this.innerProperties().vmImageRepositoryCredentials();
    }

    public VirtualMachineInner withVmImageRepositoryCredentials(ImageRepositoryCredentials vmImageRepositoryCredentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineProperties();
        }
        this.innerProperties().withVmImageRepositoryCredentials(vmImageRepositoryCredentials);
        return this;
    }

    public List<String> volumes() {
        return this.innerProperties() == null ? null : this.innerProperties().volumes();
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model VirtualMachineInner"));
        }
        this.extendedLocation().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model VirtualMachineInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInner)((Object)jsonReader.readObject(reader -> {
            VirtualMachineInner deserializedVirtualMachineInner = new VirtualMachineInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVirtualMachineInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualMachineInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVirtualMachineInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualMachineInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedVirtualMachineInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachineInner.innerProperties = VirtualMachineProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVirtualMachineInner.etag = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedVirtualMachineInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedVirtualMachineInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInner;
        }));
    }
}

