/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ConsoleEnabled;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ConsolePatchProperties
implements JsonSerializable<ConsolePatchProperties> {
    private ConsoleEnabled enabled;
    private OffsetDateTime expiration;
    private SshPublicKey sshPublicKey;

    public ConsoleEnabled enabled() {
        return this.enabled;
    }

    public ConsolePatchProperties withEnabled(ConsoleEnabled enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime expiration() {
        return this.expiration;
    }

    public ConsolePatchProperties withExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    public SshPublicKey sshPublicKey() {
        return this.sshPublicKey;
    }

    public ConsolePatchProperties withSshPublicKey(SshPublicKey sshPublicKey) {
        this.sshPublicKey = sshPublicKey;
        return this;
    }

    public void validate() {
        if (this.sshPublicKey() != null) {
            this.sshPublicKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("enabled", this.enabled == null ? null : this.enabled.toString());
        jsonWriter.writeStringField("expiration", this.expiration == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiration));
        jsonWriter.writeJsonField("sshPublicKey", (JsonSerializable)this.sshPublicKey);
        return jsonWriter.writeEndObject();
    }

    public static ConsolePatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConsolePatchProperties)jsonReader.readObject(reader -> {
            ConsolePatchProperties deserializedConsolePatchProperties = new ConsolePatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedConsolePatchProperties.enabled = ConsoleEnabled.fromString(reader.getString());
                    continue;
                }
                if ("expiration".equals(fieldName)) {
                    deserializedConsolePatchProperties.expiration = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sshPublicKey".equals(fieldName)) {
                    deserializedConsolePatchProperties.sshPublicKey = SshPublicKey.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConsolePatchProperties;
        });
    }
}

