/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ActionState;
import com.azure.resourcemanager.networkcloud.models.AdministrativeCredentials;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineCordonStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePowerState;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineProvisioningState;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineReadyState;
import com.azure.resourcemanager.networkcloud.models.CertificateInfo;
import com.azure.resourcemanager.networkcloud.models.HardwareInventory;
import com.azure.resourcemanager.networkcloud.models.HardwareValidationStatus;
import com.azure.resourcemanager.networkcloud.models.RuntimeProtectionStatus;
import com.azure.resourcemanager.networkcloud.models.SecretRotationStatus;
import java.io.IOException;
import java.util.List;

public final class BareMetalMachineProperties
implements JsonSerializable<BareMetalMachineProperties> {
    private List<ActionState> actionStates;
    private List<String> associatedResourceIds;
    private String bmcConnectionString;
    private AdministrativeCredentials bmcCredentials;
    private String bmcMacAddress;
    private String bootMacAddress;
    private CertificateInfo caCertificate;
    private String clusterId;
    private BareMetalMachineCordonStatus cordonStatus;
    private BareMetalMachineDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private HardwareInventory hardwareInventory;
    private HardwareValidationStatus hardwareValidationStatus;
    private List<String> hybridAksClustersAssociatedIds;
    private String kubernetesNodeName;
    private String kubernetesVersion;
    private String machineClusterVersion;
    private String machineDetails;
    private String machineName;
    private List<String> machineRoles;
    private String machineSkuId;
    private String oamIpv4Address;
    private String oamIpv6Address;
    private String osImage;
    private BareMetalMachinePowerState powerState;
    private BareMetalMachineProvisioningState provisioningState;
    private String rackId;
    private long rackSlot;
    private BareMetalMachineReadyState readyState;
    private RuntimeProtectionStatus runtimeProtectionStatus;
    private List<SecretRotationStatus> secretRotationStatus;
    private String serialNumber;
    private String serviceTag;
    private List<String> virtualMachinesAssociatedIds;
    private static final ClientLogger LOGGER = new ClientLogger(BareMetalMachineProperties.class);

    public List<ActionState> actionStates() {
        return this.actionStates;
    }

    public List<String> associatedResourceIds() {
        return this.associatedResourceIds;
    }

    public String bmcConnectionString() {
        return this.bmcConnectionString;
    }

    public BareMetalMachineProperties withBmcConnectionString(String bmcConnectionString) {
        this.bmcConnectionString = bmcConnectionString;
        return this;
    }

    public AdministrativeCredentials bmcCredentials() {
        return this.bmcCredentials;
    }

    public BareMetalMachineProperties withBmcCredentials(AdministrativeCredentials bmcCredentials) {
        this.bmcCredentials = bmcCredentials;
        return this;
    }

    public String bmcMacAddress() {
        return this.bmcMacAddress;
    }

    public BareMetalMachineProperties withBmcMacAddress(String bmcMacAddress) {
        this.bmcMacAddress = bmcMacAddress;
        return this;
    }

    public String bootMacAddress() {
        return this.bootMacAddress;
    }

    public BareMetalMachineProperties withBootMacAddress(String bootMacAddress) {
        this.bootMacAddress = bootMacAddress;
        return this;
    }

    public CertificateInfo caCertificate() {
        return this.caCertificate;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public BareMetalMachineCordonStatus cordonStatus() {
        return this.cordonStatus;
    }

    public BareMetalMachineDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public HardwareInventory hardwareInventory() {
        return this.hardwareInventory;
    }

    public HardwareValidationStatus hardwareValidationStatus() {
        return this.hardwareValidationStatus;
    }

    public List<String> hybridAksClustersAssociatedIds() {
        return this.hybridAksClustersAssociatedIds;
    }

    public String kubernetesNodeName() {
        return this.kubernetesNodeName;
    }

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public String machineClusterVersion() {
        return this.machineClusterVersion;
    }

    public BareMetalMachineProperties withMachineClusterVersion(String machineClusterVersion) {
        this.machineClusterVersion = machineClusterVersion;
        return this;
    }

    public String machineDetails() {
        return this.machineDetails;
    }

    public BareMetalMachineProperties withMachineDetails(String machineDetails) {
        this.machineDetails = machineDetails;
        return this;
    }

    public String machineName() {
        return this.machineName;
    }

    public BareMetalMachineProperties withMachineName(String machineName) {
        this.machineName = machineName;
        return this;
    }

    public List<String> machineRoles() {
        return this.machineRoles;
    }

    public String machineSkuId() {
        return this.machineSkuId;
    }

    public BareMetalMachineProperties withMachineSkuId(String machineSkuId) {
        this.machineSkuId = machineSkuId;
        return this;
    }

    public String oamIpv4Address() {
        return this.oamIpv4Address;
    }

    public String oamIpv6Address() {
        return this.oamIpv6Address;
    }

    public String osImage() {
        return this.osImage;
    }

    public BareMetalMachinePowerState powerState() {
        return this.powerState;
    }

    public BareMetalMachineProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String rackId() {
        return this.rackId;
    }

    public BareMetalMachineProperties withRackId(String rackId) {
        this.rackId = rackId;
        return this;
    }

    public long rackSlot() {
        return this.rackSlot;
    }

    public BareMetalMachineProperties withRackSlot(long rackSlot) {
        this.rackSlot = rackSlot;
        return this;
    }

    public BareMetalMachineReadyState readyState() {
        return this.readyState;
    }

    public RuntimeProtectionStatus runtimeProtectionStatus() {
        return this.runtimeProtectionStatus;
    }

    public List<SecretRotationStatus> secretRotationStatus() {
        return this.secretRotationStatus;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public BareMetalMachineProperties withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public String serviceTag() {
        return this.serviceTag;
    }

    public List<String> virtualMachinesAssociatedIds() {
        return this.virtualMachinesAssociatedIds;
    }

    public void validate() {
        if (this.actionStates() != null) {
            this.actionStates().forEach(e -> e.validate());
        }
        if (this.bmcConnectionString() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bmcConnectionString in model BareMetalMachineProperties"));
        }
        if (this.bmcCredentials() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bmcCredentials in model BareMetalMachineProperties"));
        }
        this.bmcCredentials().validate();
        if (this.bmcMacAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bmcMacAddress in model BareMetalMachineProperties"));
        }
        if (this.bootMacAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bootMacAddress in model BareMetalMachineProperties"));
        }
        if (this.caCertificate() != null) {
            this.caCertificate().validate();
        }
        if (this.hardwareInventory() != null) {
            this.hardwareInventory().validate();
        }
        if (this.hardwareValidationStatus() != null) {
            this.hardwareValidationStatus().validate();
        }
        if (this.machineDetails() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property machineDetails in model BareMetalMachineProperties"));
        }
        if (this.machineName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property machineName in model BareMetalMachineProperties"));
        }
        if (this.machineSkuId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property machineSkuId in model BareMetalMachineProperties"));
        }
        if (this.rackId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rackId in model BareMetalMachineProperties"));
        }
        if (this.runtimeProtectionStatus() != null) {
            this.runtimeProtectionStatus().validate();
        }
        if (this.secretRotationStatus() != null) {
            this.secretRotationStatus().forEach(e -> e.validate());
        }
        if (this.serialNumber() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serialNumber in model BareMetalMachineProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("bmcConnectionString", this.bmcConnectionString);
        jsonWriter.writeJsonField("bmcCredentials", (JsonSerializable)this.bmcCredentials);
        jsonWriter.writeStringField("bmcMacAddress", this.bmcMacAddress);
        jsonWriter.writeStringField("bootMacAddress", this.bootMacAddress);
        jsonWriter.writeStringField("machineDetails", this.machineDetails);
        jsonWriter.writeStringField("machineName", this.machineName);
        jsonWriter.writeStringField("machineSkuId", this.machineSkuId);
        jsonWriter.writeStringField("rackId", this.rackId);
        jsonWriter.writeLongField("rackSlot", this.rackSlot);
        jsonWriter.writeStringField("serialNumber", this.serialNumber);
        jsonWriter.writeStringField("machineClusterVersion", this.machineClusterVersion);
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachineProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachineProperties)jsonReader.readObject(reader -> {
            BareMetalMachineProperties deserializedBareMetalMachineProperties = new BareMetalMachineProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bmcConnectionString".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.bmcConnectionString = reader.getString();
                    continue;
                }
                if ("bmcCredentials".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.bmcCredentials = AdministrativeCredentials.fromJson(reader);
                    continue;
                }
                if ("bmcMacAddress".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.bmcMacAddress = reader.getString();
                    continue;
                }
                if ("bootMacAddress".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.bootMacAddress = reader.getString();
                    continue;
                }
                if ("machineDetails".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.machineDetails = reader.getString();
                    continue;
                }
                if ("machineName".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.machineName = reader.getString();
                    continue;
                }
                if ("machineSkuId".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.machineSkuId = reader.getString();
                    continue;
                }
                if ("rackId".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.rackId = reader.getString();
                    continue;
                }
                if ("rackSlot".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.rackSlot = reader.getLong();
                    continue;
                }
                if ("serialNumber".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.serialNumber = reader.getString();
                    continue;
                }
                if ("actionStates".equals(fieldName)) {
                    List actionStates;
                    deserializedBareMetalMachineProperties.actionStates = actionStates = reader.readArray(reader1 -> ActionState.fromJson(reader1));
                    continue;
                }
                if ("associatedResourceIds".equals(fieldName)) {
                    List associatedResourceIds;
                    deserializedBareMetalMachineProperties.associatedResourceIds = associatedResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("caCertificate".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.caCertificate = CertificateInfo.fromJson(reader);
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.clusterId = reader.getString();
                    continue;
                }
                if ("cordonStatus".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.cordonStatus = BareMetalMachineCordonStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.detailedStatus = BareMetalMachineDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("hardwareInventory".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.hardwareInventory = HardwareInventory.fromJson(reader);
                    continue;
                }
                if ("hardwareValidationStatus".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.hardwareValidationStatus = HardwareValidationStatus.fromJson(reader);
                    continue;
                }
                if ("hybridAksClustersAssociatedIds".equals(fieldName)) {
                    List hybridAksClustersAssociatedIds;
                    deserializedBareMetalMachineProperties.hybridAksClustersAssociatedIds = hybridAksClustersAssociatedIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("kubernetesNodeName".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.kubernetesNodeName = reader.getString();
                    continue;
                }
                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.kubernetesVersion = reader.getString();
                    continue;
                }
                if ("machineClusterVersion".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.machineClusterVersion = reader.getString();
                    continue;
                }
                if ("machineRoles".equals(fieldName)) {
                    List machineRoles;
                    deserializedBareMetalMachineProperties.machineRoles = machineRoles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("oamIpv4Address".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.oamIpv4Address = reader.getString();
                    continue;
                }
                if ("oamIpv6Address".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.oamIpv6Address = reader.getString();
                    continue;
                }
                if ("osImage".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.osImage = reader.getString();
                    continue;
                }
                if ("powerState".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.powerState = BareMetalMachinePowerState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.provisioningState = BareMetalMachineProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("readyState".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.readyState = BareMetalMachineReadyState.fromString(reader.getString());
                    continue;
                }
                if ("runtimeProtectionStatus".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.runtimeProtectionStatus = RuntimeProtectionStatus.fromJson(reader);
                    continue;
                }
                if ("secretRotationStatus".equals(fieldName)) {
                    List secretRotationStatus;
                    deserializedBareMetalMachineProperties.secretRotationStatus = secretRotationStatus = reader.readArray(reader1 -> SecretRotationStatus.fromJson(reader1));
                    continue;
                }
                if ("serviceTag".equals(fieldName)) {
                    deserializedBareMetalMachineProperties.serviceTag = reader.getString();
                    continue;
                }
                if ("virtualMachinesAssociatedIds".equals(fieldName)) {
                    List virtualMachinesAssociatedIds;
                    deserializedBareMetalMachineProperties.virtualMachinesAssociatedIds = virtualMachinesAssociatedIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachineProperties;
        });
    }
}

