/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.networkcloud.models.NodePoolAdministratorConfigurationPatch;
import java.io.IOException;

public final class AgentPoolPatchProperties
implements JsonSerializable<AgentPoolPatchProperties> {
    private NodePoolAdministratorConfigurationPatch administratorConfiguration;
    private Long count;
    private AgentPoolUpgradeSettings upgradeSettings;

    public NodePoolAdministratorConfigurationPatch administratorConfiguration() {
        return this.administratorConfiguration;
    }

    public AgentPoolPatchProperties withAdministratorConfiguration(NodePoolAdministratorConfigurationPatch administratorConfiguration) {
        this.administratorConfiguration = administratorConfiguration;
        return this;
    }

    public Long count() {
        return this.count;
    }

    public AgentPoolPatchProperties withCount(Long count) {
        this.count = count;
        return this;
    }

    public AgentPoolUpgradeSettings upgradeSettings() {
        return this.upgradeSettings;
    }

    public AgentPoolPatchProperties withUpgradeSettings(AgentPoolUpgradeSettings upgradeSettings) {
        this.upgradeSettings = upgradeSettings;
        return this;
    }

    public void validate() {
        if (this.administratorConfiguration() != null) {
            this.administratorConfiguration().validate();
        }
        if (this.upgradeSettings() != null) {
            this.upgradeSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("administratorConfiguration", (JsonSerializable)this.administratorConfiguration);
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeJsonField("upgradeSettings", (JsonSerializable)this.upgradeSettings);
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolPatchProperties)jsonReader.readObject(reader -> {
            AgentPoolPatchProperties deserializedAgentPoolPatchProperties = new AgentPoolPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorConfiguration".equals(fieldName)) {
                    deserializedAgentPoolPatchProperties.administratorConfiguration = NodePoolAdministratorConfigurationPatch.fromJson(reader);
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedAgentPoolPatchProperties.count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("upgradeSettings".equals(fieldName)) {
                    deserializedAgentPoolPatchProperties.upgradeSettings = AgentPoolUpgradeSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolPatchProperties;
        });
    }
}

