/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.VolumeInner;
import java.io.IOException;
import java.util.List;

public final class VolumeList
implements JsonSerializable<VolumeList> {
    private String nextLink;
    private List<VolumeInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public VolumeList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<VolumeInner> value() {
        return this.value;
    }

    public VolumeList withValue(List<VolumeInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VolumeList fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeList)jsonReader.readObject(reader -> {
            VolumeList deserializedVolumeList = new VolumeList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedVolumeList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedVolumeList.value = value = reader.readArray(reader1 -> VolumeInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeList;
        });
    }
}

