/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ServicePrincipalInformation
implements JsonSerializable<ServicePrincipalInformation> {
    private String applicationId;
    private String password;
    private String principalId;
    private String tenantId;
    private static final ClientLogger LOGGER = new ClientLogger(ServicePrincipalInformation.class);

    public String applicationId() {
        return this.applicationId;
    }

    public ServicePrincipalInformation withApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ServicePrincipalInformation withPassword(String password) {
        this.password = password;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public ServicePrincipalInformation withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ServicePrincipalInformation withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public void validate() {
        if (this.applicationId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property applicationId in model ServicePrincipalInformation"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model ServicePrincipalInformation"));
        }
        if (this.principalId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property principalId in model ServicePrincipalInformation"));
        }
        if (this.tenantId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tenantId in model ServicePrincipalInformation"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("applicationId", this.applicationId);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("tenantId", this.tenantId);
        return jsonWriter.writeEndObject();
    }

    public static ServicePrincipalInformation fromJson(JsonReader jsonReader) throws IOException {
        return (ServicePrincipalInformation)jsonReader.readObject(reader -> {
            ServicePrincipalInformation deserializedServicePrincipalInformation = new ServicePrincipalInformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("applicationId".equals(fieldName)) {
                    deserializedServicePrincipalInformation.applicationId = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedServicePrincipalInformation.password = reader.getString();
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedServicePrincipalInformation.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedServicePrincipalInformation.tenantId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServicePrincipalInformation;
        });
    }
}

