/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AttachedNetworkConfiguration;
import com.azure.resourcemanager.networkcloud.models.BgpServiceLoadBalancerConfiguration;
import com.azure.resourcemanager.networkcloud.models.L2ServiceLoadBalancerConfiguration;
import java.io.IOException;
import java.util.List;

public final class NetworkConfiguration
implements JsonSerializable<NetworkConfiguration> {
    private AttachedNetworkConfiguration attachedNetworkConfiguration;
    private BgpServiceLoadBalancerConfiguration bgpServiceLoadBalancerConfiguration;
    private String cloudServicesNetworkId;
    private String cniNetworkId;
    private String dnsServiceIp;
    private L2ServiceLoadBalancerConfiguration l2ServiceLoadBalancerConfiguration;
    private List<String> podCidrs;
    private List<String> serviceCidrs;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkConfiguration.class);

    public AttachedNetworkConfiguration attachedNetworkConfiguration() {
        return this.attachedNetworkConfiguration;
    }

    public NetworkConfiguration withAttachedNetworkConfiguration(AttachedNetworkConfiguration attachedNetworkConfiguration) {
        this.attachedNetworkConfiguration = attachedNetworkConfiguration;
        return this;
    }

    public BgpServiceLoadBalancerConfiguration bgpServiceLoadBalancerConfiguration() {
        return this.bgpServiceLoadBalancerConfiguration;
    }

    public NetworkConfiguration withBgpServiceLoadBalancerConfiguration(BgpServiceLoadBalancerConfiguration bgpServiceLoadBalancerConfiguration) {
        this.bgpServiceLoadBalancerConfiguration = bgpServiceLoadBalancerConfiguration;
        return this;
    }

    public String cloudServicesNetworkId() {
        return this.cloudServicesNetworkId;
    }

    public NetworkConfiguration withCloudServicesNetworkId(String cloudServicesNetworkId) {
        this.cloudServicesNetworkId = cloudServicesNetworkId;
        return this;
    }

    public String cniNetworkId() {
        return this.cniNetworkId;
    }

    public NetworkConfiguration withCniNetworkId(String cniNetworkId) {
        this.cniNetworkId = cniNetworkId;
        return this;
    }

    public String dnsServiceIp() {
        return this.dnsServiceIp;
    }

    public NetworkConfiguration withDnsServiceIp(String dnsServiceIp) {
        this.dnsServiceIp = dnsServiceIp;
        return this;
    }

    public L2ServiceLoadBalancerConfiguration l2ServiceLoadBalancerConfiguration() {
        return this.l2ServiceLoadBalancerConfiguration;
    }

    public NetworkConfiguration withL2ServiceLoadBalancerConfiguration(L2ServiceLoadBalancerConfiguration l2ServiceLoadBalancerConfiguration) {
        this.l2ServiceLoadBalancerConfiguration = l2ServiceLoadBalancerConfiguration;
        return this;
    }

    public List<String> podCidrs() {
        return this.podCidrs;
    }

    public NetworkConfiguration withPodCidrs(List<String> podCidrs) {
        this.podCidrs = podCidrs;
        return this;
    }

    public List<String> serviceCidrs() {
        return this.serviceCidrs;
    }

    public NetworkConfiguration withServiceCidrs(List<String> serviceCidrs) {
        this.serviceCidrs = serviceCidrs;
        return this;
    }

    public void validate() {
        if (this.attachedNetworkConfiguration() != null) {
            this.attachedNetworkConfiguration().validate();
        }
        if (this.bgpServiceLoadBalancerConfiguration() != null) {
            this.bgpServiceLoadBalancerConfiguration().validate();
        }
        if (this.cloudServicesNetworkId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property cloudServicesNetworkId in model NetworkConfiguration"));
        }
        if (this.cniNetworkId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property cniNetworkId in model NetworkConfiguration"));
        }
        if (this.l2ServiceLoadBalancerConfiguration() != null) {
            this.l2ServiceLoadBalancerConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cloudServicesNetworkId", this.cloudServicesNetworkId);
        jsonWriter.writeStringField("cniNetworkId", this.cniNetworkId);
        jsonWriter.writeJsonField("attachedNetworkConfiguration", (JsonSerializable)this.attachedNetworkConfiguration);
        jsonWriter.writeJsonField("bgpServiceLoadBalancerConfiguration", (JsonSerializable)this.bgpServiceLoadBalancerConfiguration);
        jsonWriter.writeStringField("dnsServiceIp", this.dnsServiceIp);
        jsonWriter.writeJsonField("l2ServiceLoadBalancerConfiguration", (JsonSerializable)this.l2ServiceLoadBalancerConfiguration);
        jsonWriter.writeArrayField("podCidrs", this.podCidrs, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("serviceCidrs", this.serviceCidrs, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkConfiguration)jsonReader.readObject(reader -> {
            NetworkConfiguration deserializedNetworkConfiguration = new NetworkConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cloudServicesNetworkId".equals(fieldName)) {
                    deserializedNetworkConfiguration.cloudServicesNetworkId = reader.getString();
                    continue;
                }
                if ("cniNetworkId".equals(fieldName)) {
                    deserializedNetworkConfiguration.cniNetworkId = reader.getString();
                    continue;
                }
                if ("attachedNetworkConfiguration".equals(fieldName)) {
                    deserializedNetworkConfiguration.attachedNetworkConfiguration = AttachedNetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("bgpServiceLoadBalancerConfiguration".equals(fieldName)) {
                    deserializedNetworkConfiguration.bgpServiceLoadBalancerConfiguration = BgpServiceLoadBalancerConfiguration.fromJson(reader);
                    continue;
                }
                if ("dnsServiceIp".equals(fieldName)) {
                    deserializedNetworkConfiguration.dnsServiceIp = reader.getString();
                    continue;
                }
                if ("l2ServiceLoadBalancerConfiguration".equals(fieldName)) {
                    deserializedNetworkConfiguration.l2ServiceLoadBalancerConfiguration = L2ServiceLoadBalancerConfiguration.fromJson(reader);
                    continue;
                }
                if ("podCidrs".equals(fieldName)) {
                    List podCidrs;
                    deserializedNetworkConfiguration.podCidrs = podCidrs = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("serviceCidrs".equals(fieldName)) {
                    List serviceCidrs;
                    deserializedNetworkConfiguration.serviceCidrs = serviceCidrs = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkConfiguration;
        });
    }
}

