/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterManagerInner;
import java.io.IOException;
import java.util.List;

public final class ClusterManagerList
implements JsonSerializable<ClusterManagerList> {
    private String nextLink;
    private List<ClusterManagerInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public ClusterManagerList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<ClusterManagerInner> value() {
        return this.value;
    }

    public ClusterManagerList withValue(List<ClusterManagerInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ClusterManagerList fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterManagerList)jsonReader.readObject(reader -> {
            ClusterManagerList deserializedClusterManagerList = new ClusterManagerList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedClusterManagerList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedClusterManagerList.value = value = reader.readArray(reader1 -> ClusterManagerInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterManagerList;
        });
    }
}

