/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.IdentitySelector;
import java.io.IOException;

public final class AnalyticsOutputSettings
implements JsonSerializable<AnalyticsOutputSettings> {
    private String analyticsWorkspaceId;
    private IdentitySelector associatedIdentity;

    public String analyticsWorkspaceId() {
        return this.analyticsWorkspaceId;
    }

    public AnalyticsOutputSettings withAnalyticsWorkspaceId(String analyticsWorkspaceId) {
        this.analyticsWorkspaceId = analyticsWorkspaceId;
        return this;
    }

    public IdentitySelector associatedIdentity() {
        return this.associatedIdentity;
    }

    public AnalyticsOutputSettings withAssociatedIdentity(IdentitySelector associatedIdentity) {
        this.associatedIdentity = associatedIdentity;
        return this;
    }

    public void validate() {
        if (this.associatedIdentity() != null) {
            this.associatedIdentity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("analyticsWorkspaceId", this.analyticsWorkspaceId);
        jsonWriter.writeJsonField("associatedIdentity", (JsonSerializable)this.associatedIdentity);
        return jsonWriter.writeEndObject();
    }

    public static AnalyticsOutputSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyticsOutputSettings)jsonReader.readObject(reader -> {
            AnalyticsOutputSettings deserializedAnalyticsOutputSettings = new AnalyticsOutputSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("analyticsWorkspaceId".equals(fieldName)) {
                    deserializedAnalyticsOutputSettings.analyticsWorkspaceId = reader.getString();
                    continue;
                }
                if ("associatedIdentity".equals(fieldName)) {
                    deserializedAnalyticsOutputSettings.associatedIdentity = IdentitySelector.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnalyticsOutputSettings;
        });
    }
}

