/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.TrunkedNetworkInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetwork;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworkPatchParameters;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworkProvisioningState;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class TrunkedNetworkImpl
implements TrunkedNetwork,
TrunkedNetwork.Definition,
TrunkedNetwork.Update {
    private TrunkedNetworkInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String trunkedNetworkName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private String updateIfNoneMatch;
    private TrunkedNetworkPatchParameters updateTrunkedNetworkUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<String> associatedResourceIds() {
        List<String> inner = this.innerModel().associatedResourceIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String clusterId() {
        return this.innerModel().clusterId();
    }

    @Override
    public TrunkedNetworkDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public List<String> hybridAksClustersAssociatedIds() {
        List<String> inner = this.innerModel().hybridAksClustersAssociatedIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public HybridAksPluginType hybridAksPluginType() {
        return this.innerModel().hybridAksPluginType();
    }

    @Override
    public String interfaceName() {
        return this.innerModel().interfaceName();
    }

    @Override
    public List<String> isolationDomainIds() {
        List<String> inner = this.innerModel().isolationDomainIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public TrunkedNetworkProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<String> virtualMachinesAssociatedIds() {
        List<String> inner = this.innerModel().virtualMachinesAssociatedIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> vlans() {
        List<Long> inner = this.innerModel().vlans();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public TrunkedNetworkInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public TrunkedNetworkImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public TrunkedNetwork create() {
        this.innerObject = this.serviceManager.serviceClient().getTrunkedNetworks().createOrUpdate(this.resourceGroupName, this.trunkedNetworkName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public TrunkedNetwork create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getTrunkedNetworks().createOrUpdate(this.resourceGroupName, this.trunkedNetworkName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    TrunkedNetworkImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new TrunkedNetworkInner();
        this.serviceManager = serviceManager;
        this.trunkedNetworkName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public TrunkedNetworkImpl update() {
        this.updateIfMatch = null;
        this.updateIfNoneMatch = null;
        this.updateTrunkedNetworkUpdateParameters = new TrunkedNetworkPatchParameters();
        return this;
    }

    @Override
    public TrunkedNetwork apply() {
        this.innerObject = (TrunkedNetworkInner)((Object)this.serviceManager.serviceClient().getTrunkedNetworks().updateWithResponse(this.resourceGroupName, this.trunkedNetworkName, this.updateIfMatch, this.updateIfNoneMatch, this.updateTrunkedNetworkUpdateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public TrunkedNetwork apply(Context context) {
        this.innerObject = (TrunkedNetworkInner)((Object)this.serviceManager.serviceClient().getTrunkedNetworks().updateWithResponse(this.resourceGroupName, this.trunkedNetworkName, this.updateIfMatch, this.updateIfNoneMatch, this.updateTrunkedNetworkUpdateParameters, context).getValue());
        return this;
    }

    TrunkedNetworkImpl(TrunkedNetworkInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.trunkedNetworkName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "trunkedNetworks");
    }

    @Override
    public TrunkedNetwork refresh() {
        this.innerObject = (TrunkedNetworkInner)((Object)this.serviceManager.serviceClient().getTrunkedNetworks().getByResourceGroupWithResponse(this.resourceGroupName, this.trunkedNetworkName, Context.NONE).getValue());
        return this;
    }

    @Override
    public TrunkedNetwork refresh(Context context) {
        this.innerObject = (TrunkedNetworkInner)((Object)this.serviceManager.serviceClient().getTrunkedNetworks().getByResourceGroupWithResponse(this.resourceGroupName, this.trunkedNetworkName, context).getValue());
        return this;
    }

    @Override
    public TrunkedNetworkImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public TrunkedNetworkImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public TrunkedNetworkImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public TrunkedNetworkImpl withIsolationDomainIds(List<String> isolationDomainIds) {
        this.innerModel().withIsolationDomainIds(isolationDomainIds);
        return this;
    }

    @Override
    public TrunkedNetworkImpl withVlans(List<Long> vlans) {
        this.innerModel().withVlans(vlans);
        return this;
    }

    @Override
    public TrunkedNetworkImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateTrunkedNetworkUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public TrunkedNetworkImpl withHybridAksPluginType(HybridAksPluginType hybridAksPluginType) {
        this.innerModel().withHybridAksPluginType(hybridAksPluginType);
        return this;
    }

    @Override
    public TrunkedNetworkImpl withInterfaceName(String interfaceName) {
        this.innerModel().withInterfaceName(interfaceName);
        return this;
    }

    @Override
    public TrunkedNetworkImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public TrunkedNetworkImpl withIfNoneMatch(String ifNoneMatch) {
        if (this.isInCreateMode()) {
            this.createIfNoneMatch = ifNoneMatch;
            return this;
        }
        this.updateIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

