/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.ConsolesClient;
import com.azure.resourcemanager.networkcloud.fluent.models.ConsoleInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.ConsoleImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.Console;
import com.azure.resourcemanager.networkcloud.models.Consoles;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class ConsolesImpl
implements Consoles {
    private static final ClientLogger LOGGER = new ClientLogger(ConsolesImpl.class);
    private final ConsolesClient innerClient;
    private final NetworkCloudManager serviceManager;

    public ConsolesImpl(ConsolesClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Console> listByVirtualMachine(String resourceGroupName, String virtualMachineName) {
        PagedIterable<ConsoleInner> inner = this.serviceClient().listByVirtualMachine(resourceGroupName, virtualMachineName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConsoleImpl((ConsoleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Console> listByVirtualMachine(String resourceGroupName, String virtualMachineName, Context context) {
        PagedIterable<ConsoleInner> inner = this.serviceClient().listByVirtualMachine(resourceGroupName, virtualMachineName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConsoleImpl((ConsoleInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Console> getWithResponse(String resourceGroupName, String virtualMachineName, String consoleName, Context context) {
        Response<ConsoleInner> inner = this.serviceClient().getWithResponse(resourceGroupName, virtualMachineName, consoleName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConsoleImpl((ConsoleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Console get(String resourceGroupName, String virtualMachineName, String consoleName) {
        ConsoleInner inner = this.serviceClient().get(resourceGroupName, virtualMachineName, consoleName);
        if (inner != null) {
            return new ConsoleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String virtualMachineName, String consoleName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, virtualMachineName, consoleName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Console getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (virtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        String consoleName = ResourceManagerUtils.getValueFromIdByName(id, "consoles");
        if (consoleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'consoles'.", id)));
        }
        return (Console)this.getWithResponse(resourceGroupName, virtualMachineName, consoleName, Context.NONE).getValue();
    }

    @Override
    public Response<Console> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (virtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        String consoleName = ResourceManagerUtils.getValueFromIdByName(id, "consoles");
        if (consoleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'consoles'.", id)));
        }
        return this.getWithResponse(resourceGroupName, virtualMachineName, consoleName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (virtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        String consoleName = ResourceManagerUtils.getValueFromIdByName(id, "consoles");
        if (consoleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'consoles'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, virtualMachineName, consoleName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (virtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        String consoleName = ResourceManagerUtils.getValueFromIdByName(id, "consoles");
        if (consoleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'consoles'.", id)));
        }
        return this.delete(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, context);
    }

    private ConsolesClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConsoleImpl define(String name) {
        return new ConsoleImpl(name, this.manager());
    }
}

