/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.networkcloud.fluent.ConsolesClient;
import com.azure.resourcemanager.networkcloud.fluent.models.ConsoleInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudImpl;
import com.azure.resourcemanager.networkcloud.models.ConsoleList;
import com.azure.resourcemanager.networkcloud.models.ConsolePatchParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ConsolesClientImpl
implements ConsolesClient {
    private final ConsolesService service;
    private final NetworkCloudImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ConsolesClientImpl.class);

    ConsolesClientImpl(NetworkCloudImpl client) {
        this.service = (ConsolesService)RestProxy.create(ConsolesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConsoleInner>> listByVirtualMachineSinglePageAsync(String resourceGroupName, String virtualMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualMachine(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConsoleList)res.getValue()).value(), ((ConsoleList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConsoleInner> listByVirtualMachineAsync(String resourceGroupName, String virtualMachineName) {
        return new PagedFlux(() -> this.listByVirtualMachineSinglePageAsync(resourceGroupName, virtualMachineName), nextLink -> this.listByVirtualMachineNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ConsoleInner> listByVirtualMachineSinglePage(String resourceGroupName, String virtualMachineName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ConsoleList> res = this.service.listByVirtualMachineSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConsoleList)res.getValue()).value(), ((ConsoleList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ConsoleInner> listByVirtualMachineSinglePage(String resourceGroupName, String virtualMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ConsoleList> res = this.service.listByVirtualMachineSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConsoleList)res.getValue()).value(), ((ConsoleList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConsoleInner> listByVirtualMachine(String resourceGroupName, String virtualMachineName) {
        return new PagedIterable(() -> this.listByVirtualMachineSinglePage(resourceGroupName, virtualMachineName), nextLink -> this.listByVirtualMachineNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConsoleInner> listByVirtualMachine(String resourceGroupName, String virtualMachineName, Context context) {
        return new PagedIterable(() -> this.listByVirtualMachineSinglePage(resourceGroupName, virtualMachineName, context), nextLink -> this.listByVirtualMachineNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConsoleInner>> getWithResponseAsync(String resourceGroupName, String virtualMachineName, String consoleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        if (consoleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consoleName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, consoleName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConsoleInner> getAsync(String resourceGroupName, String virtualMachineName, String consoleName) {
        return this.getWithResponseAsync(resourceGroupName, virtualMachineName, consoleName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConsoleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConsoleInner> getWithResponse(String resourceGroupName, String virtualMachineName, String consoleName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        if (consoleName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter consoleName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, consoleName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConsoleInner get(String resourceGroupName, String virtualMachineName, String consoleName) {
        return (ConsoleInner)((Object)this.getWithResponse(resourceGroupName, virtualMachineName, consoleName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        if (consoleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consoleName is required and cannot be null."));
        }
        if (consoleParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consoleParameters is required and cannot be null."));
        }
        consoleParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        if (consoleName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter consoleName is required and cannot be null."));
        }
        if (consoleParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter consoleParameters is required and cannot be null."));
        }
        consoleParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        if (consoleName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter consoleName is required and cannot be null."));
        }
        if (consoleParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter consoleParameters is required and cannot be null."));
        }
        consoleParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConsoleInner>, ConsoleInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, virtualMachineName, consoleName, consoleParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConsoleInner.class), (Type)((Object)ConsoleInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConsoleInner>, ConsoleInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, virtualMachineName, consoleName, consoleParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConsoleInner.class), (Type)((Object)ConsoleInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConsoleInner>, ConsoleInner> beginCreateOrUpdate(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, virtualMachineName, consoleName, consoleParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)ConsoleInner.class), (Type)((Object)ConsoleInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConsoleInner>, ConsoleInner> beginCreateOrUpdate(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, virtualMachineName, consoleName, consoleParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)ConsoleInner.class), (Type)((Object)ConsoleInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConsoleInner>, ConsoleInner> beginCreateOrUpdate(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, virtualMachineName, consoleName, consoleParameters, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)ConsoleInner.class), (Type)((Object)ConsoleInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConsoleInner> createOrUpdateAsync(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualMachineName, consoleName, consoleParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConsoleInner> createOrUpdateAsync(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, virtualMachineName, consoleName, consoleParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConsoleInner createOrUpdate(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (ConsoleInner)((Object)this.beginCreateOrUpdate(resourceGroupName, virtualMachineName, consoleName, consoleParameters, ifMatch, ifNoneMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConsoleInner createOrUpdate(String resourceGroupName, String virtualMachineName, String consoleName, ConsoleInner consoleParameters, String ifMatch, String ifNoneMatch, Context context) {
        return (ConsoleInner)((Object)this.beginCreateOrUpdate(resourceGroupName, virtualMachineName, consoleName, consoleParameters, ifMatch, ifNoneMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        if (consoleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consoleName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        if (consoleName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter consoleName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        if (consoleName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter consoleName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String virtualMachineName, String consoleName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String virtualMachineName, String consoleName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch) {
        return this.beginDeleteAsync(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String virtualMachineName, String consoleName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginDeleteAsync(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String virtualMachineName, String consoleName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, Context context) {
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, ConsolePatchParameters consoleUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        if (consoleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consoleName is required and cannot be null."));
        }
        if (consoleUpdateParameters != null) {
            consoleUpdateParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, ConsolePatchParameters consoleUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        if (consoleName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter consoleName is required and cannot be null."));
        }
        if (consoleUpdateParameters != null) {
            consoleUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, ConsolePatchParameters consoleUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter virtualMachineName is required and cannot be null."));
        }
        if (consoleName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter consoleName is required and cannot be null."));
        }
        if (consoleUpdateParameters != null) {
            consoleUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConsoleInner>, ConsoleInner> beginUpdateAsync(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, ConsolePatchParameters consoleUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConsoleInner.class), (Type)((Object)ConsoleInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConsoleInner>, ConsoleInner> beginUpdateAsync(String resourceGroupName, String virtualMachineName, String consoleName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        ConsolePatchParameters consoleUpdateParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConsoleInner.class), (Type)((Object)ConsoleInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConsoleInner>, ConsoleInner> beginUpdate(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, ConsolePatchParameters consoleUpdateParameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)ConsoleInner.class), (Type)((Object)ConsoleInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConsoleInner>, ConsoleInner> beginUpdate(String resourceGroupName, String virtualMachineName, String consoleName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        ConsolePatchParameters consoleUpdateParameters = null;
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)ConsoleInner.class), (Type)((Object)ConsoleInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConsoleInner>, ConsoleInner> beginUpdate(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, ConsolePatchParameters consoleUpdateParameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters, context);
        return this.client.getLroResult(response, (Type)((Object)ConsoleInner.class), (Type)((Object)ConsoleInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConsoleInner> updateAsync(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, ConsolePatchParameters consoleUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConsoleInner> updateAsync(String resourceGroupName, String virtualMachineName, String consoleName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        ConsolePatchParameters consoleUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConsoleInner update(String resourceGroupName, String virtualMachineName, String consoleName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        ConsolePatchParameters consoleUpdateParameters = null;
        return (ConsoleInner)((Object)this.beginUpdate(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConsoleInner update(String resourceGroupName, String virtualMachineName, String consoleName, String ifMatch, String ifNoneMatch, ConsolePatchParameters consoleUpdateParameters, Context context) {
        return (ConsoleInner)((Object)this.beginUpdate(resourceGroupName, virtualMachineName, consoleName, ifMatch, ifNoneMatch, consoleUpdateParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConsoleInner>> listByVirtualMachineNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualMachineNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConsoleList)res.getValue()).value(), ((ConsoleList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ConsoleInner> listByVirtualMachineNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ConsoleList> res = this.service.listByVirtualMachineNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConsoleList)res.getValue()).value(), ((ConsoleList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ConsoleInner> listByVirtualMachineNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ConsoleList> res = this.service.listByVirtualMachineNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConsoleList)res.getValue()).value(), ((ConsoleList)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkCloudConsoles")
    public static interface ConsolesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConsoleList>> listByVirtualMachine(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ConsoleList> listByVirtualMachineSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles/{consoleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConsoleInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualMachineName") String var5, @PathParam(value="consoleName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles/{consoleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ConsoleInner> getSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualMachineName") String var5, @PathParam(value="consoleName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles/{consoleName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualMachineName") String var5, @PathParam(value="consoleName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") ConsoleInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles/{consoleName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualMachineName") String var5, @PathParam(value="consoleName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") ConsoleInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles/{consoleName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualMachineName") String var5, @PathParam(value="consoleName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles/{consoleName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualMachineName") String var5, @PathParam(value="consoleName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles/{consoleName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualMachineName") String var5, @PathParam(value="consoleName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") ConsolePatchParameters var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles/{consoleName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualMachineName") String var5, @PathParam(value="consoleName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") ConsolePatchParameters var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConsoleList>> listByVirtualMachineNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ConsoleList> listByVirtualMachineNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

