/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.networkcloud.fluent.BareMetalMachinesClient;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudImpl;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineCordonParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineList;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePatchParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePowerOffParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineReplaceParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunCommandParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunDataExtractsParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunReadCommandsParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BareMetalMachinesClientImpl
implements BareMetalMachinesClient {
    private final BareMetalMachinesService service;
    private final NetworkCloudImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(BareMetalMachinesClientImpl.class);

    BareMetalMachinesClientImpl(NetworkCloudImpl client) {
        this.service = (BareMetalMachinesService)RestProxy.create(BareMetalMachinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BareMetalMachineInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BareMetalMachineInner> listSinglePage() {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BareMetalMachineList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BareMetalMachineInner> listSinglePage(Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BareMetalMachineList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BareMetalMachineInner> list() {
        return new PagedIterable(() -> this.listSinglePage(), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BareMetalMachineInner> list(Context context) {
        return new PagedIterable(() -> this.listSinglePage(context), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BareMetalMachineInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BareMetalMachineInner> listByResourceGroupSinglePage(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BareMetalMachineList> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BareMetalMachineInner> listByResourceGroupSinglePage(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BareMetalMachineList> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BareMetalMachineInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BareMetalMachineInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BareMetalMachineInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineInner> getByResourceGroupAsync(String resourceGroupName, String bareMetalMachineName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, bareMetalMachineName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BareMetalMachineInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BareMetalMachineInner> getByResourceGroupWithResponse(String resourceGroupName, String bareMetalMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineInner getByResourceGroup(String resourceGroupName, String bareMetalMachineName) {
        return (BareMetalMachineInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, bareMetalMachineName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineParameters is required and cannot be null."));
        }
        bareMetalMachineParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineParameters is required and cannot be null."));
        }
        bareMetalMachineParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineParameters is required and cannot be null."));
        }
        bareMetalMachineParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginCreateOrUpdateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginCreateOrUpdateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginCreateOrUpdate(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginCreateOrUpdate(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginCreateOrUpdate(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineInner> createOrUpdateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineInner> createOrUpdateAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineInner createOrUpdate(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (BareMetalMachineInner)((Object)this.beginCreateOrUpdate(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, ifMatch, ifNoneMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineInner createOrUpdate(String resourceGroupName, String bareMetalMachineName, BareMetalMachineInner bareMetalMachineParameters, String ifMatch, String ifNoneMatch, Context context) {
        return (BareMetalMachineInner)((Object)this.beginCreateOrUpdate(resourceGroupName, bareMetalMachineName, bareMetalMachineParameters, ifMatch, ifNoneMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String bareMetalMachineName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String bareMetalMachineName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch) {
        return this.beginDeleteAsync(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String bareMetalMachineName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginDeleteAsync(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String bareMetalMachineName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, Context context) {
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineUpdateParameters != null) {
            bareMetalMachineUpdateParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineUpdateParameters != null) {
            bareMetalMachineUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineUpdateParameters != null) {
            bareMetalMachineUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginUpdateAsync(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginUpdateAsync(String resourceGroupName, String bareMetalMachineName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        BareMetalMachinePatchParameters bareMetalMachineUpdateParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginUpdate(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginUpdate(String resourceGroupName, String bareMetalMachineName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        BareMetalMachinePatchParameters bareMetalMachineUpdateParameters = null;
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineInner>, BareMetalMachineInner> beginUpdate(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters, context);
        return this.client.getLroResult(response, (Type)((Object)BareMetalMachineInner.class), (Type)((Object)BareMetalMachineInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineInner> updateAsync(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineInner> updateAsync(String resourceGroupName, String bareMetalMachineName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        BareMetalMachinePatchParameters bareMetalMachineUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineInner update(String resourceGroupName, String bareMetalMachineName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        BareMetalMachinePatchParameters bareMetalMachineUpdateParameters = null;
        return (BareMetalMachineInner)((Object)this.beginUpdate(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineInner update(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, BareMetalMachinePatchParameters bareMetalMachineUpdateParameters, Context context) {
        return (BareMetalMachineInner)((Object)this.beginUpdate(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, bareMetalMachineUpdateParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> cordonWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineCordonParameters != null) {
            bareMetalMachineCordonParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cordon(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> cordonWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineCordonParameters != null) {
            bareMetalMachineCordonParameters.validate();
        }
        String accept = "application/json";
        return this.service.cordonSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> cordonWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineCordonParameters != null) {
            bareMetalMachineCordonParameters.validate();
        }
        String accept = "application/json";
        return this.service.cordonSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginCordonAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.cordonWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginCordonAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineCordonParameters bareMetalMachineCordonParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.cordonWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginCordon(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters) {
        Response<BinaryData> response = this.cordonWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginCordon(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineCordonParameters bareMetalMachineCordonParameters = null;
        Response<BinaryData> response = this.cordonWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginCordon(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters, Context context) {
        Response<BinaryData> response = this.cordonWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> cordonAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters) {
        return this.beginCordonAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> cordonAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineCordonParameters bareMetalMachineCordonParameters = null;
        return this.beginCordonAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner cordon(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineCordonParameters bareMetalMachineCordonParameters = null;
        return (OperationStatusResultInner)this.beginCordon(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner cordon(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters, Context context) {
        return (OperationStatusResultInner)this.beginCordon(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachinePowerOffParameters != null) {
            bareMetalMachinePowerOffParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.powerOff(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> powerOffWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachinePowerOffParameters != null) {
            bareMetalMachinePowerOffParameters.validate();
        }
        String accept = "application/json";
        return this.service.powerOffSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> powerOffWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachinePowerOffParameters != null) {
            bareMetalMachinePowerOffParameters.validate();
        }
        String accept = "application/json";
        return this.service.powerOffSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginPowerOffAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginPowerOffAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginPowerOff(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters) {
        Response<BinaryData> response = this.powerOffWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginPowerOff(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters = null;
        Response<BinaryData> response = this.powerOffWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginPowerOff(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters, Context context) {
        Response<BinaryData> response = this.powerOffWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> powerOffAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters) {
        return this.beginPowerOffAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> powerOffAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters = null;
        return this.beginPowerOffAsync(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner powerOff(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters = null;
        return (OperationStatusResultInner)this.beginPowerOff(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner powerOff(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters, Context context) {
        return (OperationStatusResultInner)this.beginPowerOff(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.reimage(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> reimageWithResponse(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.reimageSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> reimageWithResponse(String resourceGroupName, String bareMetalMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.reimageSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReimageAsync(String resourceGroupName, String bareMetalMachineName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReimage(String resourceGroupName, String bareMetalMachineName) {
        Response<BinaryData> response = this.reimageWithResponse(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReimage(String resourceGroupName, String bareMetalMachineName, Context context) {
        Response<BinaryData> response = this.reimageWithResponse(resourceGroupName, bareMetalMachineName, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> reimageAsync(String resourceGroupName, String bareMetalMachineName) {
        return this.beginReimageAsync(resourceGroupName, bareMetalMachineName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner reimage(String resourceGroupName, String bareMetalMachineName) {
        return (OperationStatusResultInner)this.beginReimage(resourceGroupName, bareMetalMachineName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner reimage(String resourceGroupName, String bareMetalMachineName, Context context) {
        return (OperationStatusResultInner)this.beginReimage(resourceGroupName, bareMetalMachineName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> replaceWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineReplaceParameters != null) {
            bareMetalMachineReplaceParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.replace(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> replaceWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineReplaceParameters != null) {
            bareMetalMachineReplaceParameters.validate();
        }
        String accept = "application/json";
        return this.service.replaceSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> replaceWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineReplaceParameters != null) {
            bareMetalMachineReplaceParameters.validate();
        }
        String accept = "application/json";
        return this.service.replaceSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReplaceAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.replaceWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReplaceAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.replaceWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReplace(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters) {
        Response<BinaryData> response = this.replaceWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReplace(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters = null;
        Response<BinaryData> response = this.replaceWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginReplace(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters, Context context) {
        Response<BinaryData> response = this.replaceWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> replaceAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters) {
        return this.beginReplaceAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> replaceAsync(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters = null;
        return this.beginReplaceAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner replace(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters = null;
        return (OperationStatusResultInner)this.beginReplace(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner replace(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters, Context context) {
        return (OperationStatusResultInner)this.beginReplace(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restart(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restartWithResponse(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.restartSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restartWithResponse(String resourceGroupName, String bareMetalMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.restartSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRestartAsync(String resourceGroupName, String bareMetalMachineName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRestart(String resourceGroupName, String bareMetalMachineName) {
        Response<BinaryData> response = this.restartWithResponse(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRestart(String resourceGroupName, String bareMetalMachineName, Context context) {
        Response<BinaryData> response = this.restartWithResponse(resourceGroupName, bareMetalMachineName, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> restartAsync(String resourceGroupName, String bareMetalMachineName) {
        return this.beginRestartAsync(resourceGroupName, bareMetalMachineName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner restart(String resourceGroupName, String bareMetalMachineName) {
        return (OperationStatusResultInner)this.beginRestart(resourceGroupName, bareMetalMachineName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner restart(String resourceGroupName, String bareMetalMachineName, Context context) {
        return (OperationStatusResultInner)this.beginRestart(resourceGroupName, bareMetalMachineName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> runCommandWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunCommandParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineRunCommandParameters is required and cannot be null."));
        }
        bareMetalMachineRunCommandParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.runCommand(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> runCommandWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunCommandParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineRunCommandParameters is required and cannot be null."));
        }
        bareMetalMachineRunCommandParameters.validate();
        String accept = "application/json";
        return this.service.runCommandSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> runCommandWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunCommandParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineRunCommandParameters is required and cannot be null."));
        }
        bareMetalMachineRunCommandParameters.validate();
        String accept = "application/json";
        return this.service.runCommandSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunCommandAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.runCommandWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunCommand(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        Response<BinaryData> response = this.runCommandWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunCommand(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters, Context context) {
        Response<BinaryData> response = this.runCommandWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> runCommandAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        return this.beginRunCommandAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runCommand(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        return (OperationStatusResultInner)this.beginRunCommand(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runCommand(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters, Context context) {
        return (OperationStatusResultInner)this.beginRunCommand(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> runDataExtractsWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunDataExtractsParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineRunDataExtractsParameters is required and cannot be null."));
        }
        bareMetalMachineRunDataExtractsParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.runDataExtracts(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> runDataExtractsWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunDataExtractsParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineRunDataExtractsParameters is required and cannot be null."));
        }
        bareMetalMachineRunDataExtractsParameters.validate();
        String accept = "application/json";
        return this.service.runDataExtractsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> runDataExtractsWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunDataExtractsParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineRunDataExtractsParameters is required and cannot be null."));
        }
        bareMetalMachineRunDataExtractsParameters.validate();
        String accept = "application/json";
        return this.service.runDataExtractsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunDataExtractsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.runDataExtractsWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunDataExtracts(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        Response<BinaryData> response = this.runDataExtractsWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunDataExtracts(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters, Context context) {
        Response<BinaryData> response = this.runDataExtractsWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> runDataExtractsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        return this.beginRunDataExtractsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runDataExtracts(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        return (OperationStatusResultInner)this.beginRunDataExtracts(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runDataExtracts(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters, Context context) {
        return (OperationStatusResultInner)this.beginRunDataExtracts(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> runReadCommandsWithResponseAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunReadCommandsParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineRunReadCommandsParameters is required and cannot be null."));
        }
        bareMetalMachineRunReadCommandsParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.runReadCommands(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> runReadCommandsWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunReadCommandsParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineRunReadCommandsParameters is required and cannot be null."));
        }
        bareMetalMachineRunReadCommandsParameters.validate();
        String accept = "application/json";
        return this.service.runReadCommandsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> runReadCommandsWithResponse(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        if (bareMetalMachineRunReadCommandsParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineRunReadCommandsParameters is required and cannot be null."));
        }
        bareMetalMachineRunReadCommandsParameters.validate();
        String accept = "application/json";
        return this.service.runReadCommandsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunReadCommandsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.runReadCommandsWithResponseAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunReadCommands(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        Response<BinaryData> response = this.runReadCommandsWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginRunReadCommands(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters, Context context) {
        Response<BinaryData> response = this.runReadCommandsWithResponse(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> runReadCommandsAsync(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        return this.beginRunReadCommandsAsync(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runReadCommands(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        return (OperationStatusResultInner)this.beginRunReadCommands(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner runReadCommands(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters, Context context) {
        return (OperationStatusResultInner)this.beginRunReadCommands(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> startWithResponse(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.startSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> startWithResponse(String resourceGroupName, String bareMetalMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.startSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStartAsync(String resourceGroupName, String bareMetalMachineName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStart(String resourceGroupName, String bareMetalMachineName) {
        Response<BinaryData> response = this.startWithResponse(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStart(String resourceGroupName, String bareMetalMachineName, Context context) {
        Response<BinaryData> response = this.startWithResponse(resourceGroupName, bareMetalMachineName, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> startAsync(String resourceGroupName, String bareMetalMachineName) {
        return this.beginStartAsync(resourceGroupName, bareMetalMachineName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner start(String resourceGroupName, String bareMetalMachineName) {
        return (OperationStatusResultInner)this.beginStart(resourceGroupName, bareMetalMachineName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner start(String resourceGroupName, String bareMetalMachineName, Context context) {
        return (OperationStatusResultInner)this.beginStart(resourceGroupName, bareMetalMachineName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> uncordonWithResponseAsync(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.uncordon(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> uncordonWithResponse(String resourceGroupName, String bareMetalMachineName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.uncordonSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> uncordonWithResponse(String resourceGroupName, String bareMetalMachineName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (bareMetalMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter bareMetalMachineName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.uncordonSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, bareMetalMachineName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginUncordonAsync(String resourceGroupName, String bareMetalMachineName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.uncordonWithResponseAsync(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginUncordon(String resourceGroupName, String bareMetalMachineName) {
        Response<BinaryData> response = this.uncordonWithResponse(resourceGroupName, bareMetalMachineName);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginUncordon(String resourceGroupName, String bareMetalMachineName, Context context) {
        Response<BinaryData> response = this.uncordonWithResponse(resourceGroupName, bareMetalMachineName, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> uncordonAsync(String resourceGroupName, String bareMetalMachineName) {
        return this.beginUncordonAsync(resourceGroupName, bareMetalMachineName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner uncordon(String resourceGroupName, String bareMetalMachineName) {
        return (OperationStatusResultInner)this.beginUncordon(resourceGroupName, bareMetalMachineName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner uncordon(String resourceGroupName, String bareMetalMachineName, Context context) {
        return (OperationStatusResultInner)this.beginUncordon(resourceGroupName, bareMetalMachineName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BareMetalMachineInner> listBySubscriptionNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BareMetalMachineList> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BareMetalMachineInner> listBySubscriptionNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BareMetalMachineList> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BareMetalMachineInner> listByResourceGroupNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BareMetalMachineList> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BareMetalMachineInner> listByResourceGroupNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<BareMetalMachineList> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineList)res.getValue()).value(), ((BareMetalMachineList)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkCloudBareMetalMachines")
    public static interface BareMetalMachinesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.NetworkCloud/bareMetalMachines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.NetworkCloud/bareMetalMachines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BareMetalMachineList> listSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineList>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BareMetalMachineList> listByResourceGroupSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineInner>> getByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BareMetalMachineInner> getByResourceGroupSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @BodyParam(value="application/json") BareMetalMachineInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @BodyParam(value="application/json") BareMetalMachineInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @BodyParam(value="application/json") BareMetalMachinePatchParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @BodyParam(value="application/json") BareMetalMachinePatchParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/cordon")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> cordon(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineCordonParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/cordon")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> cordonSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineCordonParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/powerOff")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> powerOff(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachinePowerOffParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/powerOff")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> powerOffSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachinePowerOffParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/reimage")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> reimage(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/reimage")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> reimageSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/replace")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> replace(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineReplaceParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/replace")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> replaceSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineReplaceParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/restart")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restart(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/restart")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> restartSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/runCommand")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> runCommand(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineRunCommandParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/runCommand")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> runCommandSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineRunCommandParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/runDataExtracts")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> runDataExtracts(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineRunDataExtractsParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/runDataExtracts")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> runDataExtractsSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineRunDataExtractsParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/runReadCommands")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> runReadCommands(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineRunReadCommandsParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/runReadCommands")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> runReadCommandsSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @BodyParam(value="application/json") BareMetalMachineRunReadCommandsParameters var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> startSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/uncordon")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> uncordon(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}/uncordon")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> uncordonSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="bareMetalMachineName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineList>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BareMetalMachineList> listBySubscriptionNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineList>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BareMetalMachineList> listByResourceGroupNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

