/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.RackSkuProperties;
import com.azure.resourcemanager.networkcloud.models.MachineSkuSlot;
import com.azure.resourcemanager.networkcloud.models.RackSkuProvisioningState;
import com.azure.resourcemanager.networkcloud.models.RackSkuType;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceSkuSlot;
import java.io.IOException;
import java.util.List;

public final class RackSkuInner
extends ProxyResource {
    private RackSkuProperties innerProperties = new RackSkuProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(RackSkuInner.class);

    private RackSkuProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public List<MachineSkuSlot> computeMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().computeMachines();
    }

    public List<MachineSkuSlot> controllerMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().controllerMachines();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public Long maxClusterSlots() {
        return this.innerProperties() == null ? null : this.innerProperties().maxClusterSlots();
    }

    public RackSkuProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public RackSkuType rackType() {
        return this.innerProperties() == null ? null : this.innerProperties().rackType();
    }

    public List<StorageApplianceSkuSlot> storageAppliances() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAppliances();
    }

    public List<String> supportedRackSkuIds() {
        return this.innerProperties() == null ? null : this.innerProperties().supportedRackSkuIds();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model RackSkuInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RackSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return (RackSkuInner)((Object)jsonReader.readObject(reader -> {
            RackSkuInner deserializedRackSkuInner = new RackSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRackSkuInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRackSkuInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRackSkuInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRackSkuInner.innerProperties = RackSkuProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedRackSkuInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRackSkuInner;
        }));
    }
}

