/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.HybridAksIpamEnabled;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.IpAllocationType;
import com.azure.resourcemanager.networkcloud.models.L3NetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.L3NetworkProvisioningState;
import java.io.IOException;
import java.util.List;

public final class L3NetworkProperties
implements JsonSerializable<L3NetworkProperties> {
    private List<String> associatedResourceIds;
    private String clusterId;
    private L3NetworkDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private List<String> hybridAksClustersAssociatedIds;
    private HybridAksIpamEnabled hybridAksIpamEnabled;
    private HybridAksPluginType hybridAksPluginType;
    private String interfaceName;
    private IpAllocationType ipAllocationType;
    private String ipv4ConnectedPrefix;
    private String ipv6ConnectedPrefix;
    private String l3IsolationDomainId;
    private L3NetworkProvisioningState provisioningState;
    private List<String> virtualMachinesAssociatedIds;
    private long vlan;
    private static final ClientLogger LOGGER = new ClientLogger(L3NetworkProperties.class);

    public List<String> associatedResourceIds() {
        return this.associatedResourceIds;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public L3NetworkDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public List<String> hybridAksClustersAssociatedIds() {
        return this.hybridAksClustersAssociatedIds;
    }

    public HybridAksIpamEnabled hybridAksIpamEnabled() {
        return this.hybridAksIpamEnabled;
    }

    public L3NetworkProperties withHybridAksIpamEnabled(HybridAksIpamEnabled hybridAksIpamEnabled) {
        this.hybridAksIpamEnabled = hybridAksIpamEnabled;
        return this;
    }

    public HybridAksPluginType hybridAksPluginType() {
        return this.hybridAksPluginType;
    }

    public L3NetworkProperties withHybridAksPluginType(HybridAksPluginType hybridAksPluginType) {
        this.hybridAksPluginType = hybridAksPluginType;
        return this;
    }

    public String interfaceName() {
        return this.interfaceName;
    }

    public L3NetworkProperties withInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
        return this;
    }

    public IpAllocationType ipAllocationType() {
        return this.ipAllocationType;
    }

    public L3NetworkProperties withIpAllocationType(IpAllocationType ipAllocationType) {
        this.ipAllocationType = ipAllocationType;
        return this;
    }

    public String ipv4ConnectedPrefix() {
        return this.ipv4ConnectedPrefix;
    }

    public L3NetworkProperties withIpv4ConnectedPrefix(String ipv4ConnectedPrefix) {
        this.ipv4ConnectedPrefix = ipv4ConnectedPrefix;
        return this;
    }

    public String ipv6ConnectedPrefix() {
        return this.ipv6ConnectedPrefix;
    }

    public L3NetworkProperties withIpv6ConnectedPrefix(String ipv6ConnectedPrefix) {
        this.ipv6ConnectedPrefix = ipv6ConnectedPrefix;
        return this;
    }

    public String l3IsolationDomainId() {
        return this.l3IsolationDomainId;
    }

    public L3NetworkProperties withL3IsolationDomainId(String l3IsolationDomainId) {
        this.l3IsolationDomainId = l3IsolationDomainId;
        return this;
    }

    public L3NetworkProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<String> virtualMachinesAssociatedIds() {
        return this.virtualMachinesAssociatedIds;
    }

    public long vlan() {
        return this.vlan;
    }

    public L3NetworkProperties withVlan(long vlan) {
        this.vlan = vlan;
        return this;
    }

    public void validate() {
        if (this.l3IsolationDomainId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property l3IsolationDomainId in model L3NetworkProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("l3IsolationDomainId", this.l3IsolationDomainId);
        jsonWriter.writeLongField("vlan", this.vlan);
        jsonWriter.writeStringField("hybridAksIpamEnabled", this.hybridAksIpamEnabled == null ? null : this.hybridAksIpamEnabled.toString());
        jsonWriter.writeStringField("hybridAksPluginType", this.hybridAksPluginType == null ? null : this.hybridAksPluginType.toString());
        jsonWriter.writeStringField("interfaceName", this.interfaceName);
        jsonWriter.writeStringField("ipAllocationType", this.ipAllocationType == null ? null : this.ipAllocationType.toString());
        jsonWriter.writeStringField("ipv4ConnectedPrefix", this.ipv4ConnectedPrefix);
        jsonWriter.writeStringField("ipv6ConnectedPrefix", this.ipv6ConnectedPrefix);
        return jsonWriter.writeEndObject();
    }

    public static L3NetworkProperties fromJson(JsonReader jsonReader) throws IOException {
        return (L3NetworkProperties)jsonReader.readObject(reader -> {
            L3NetworkProperties deserializedL3NetworkProperties = new L3NetworkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("l3IsolationDomainId".equals(fieldName)) {
                    deserializedL3NetworkProperties.l3IsolationDomainId = reader.getString();
                    continue;
                }
                if ("vlan".equals(fieldName)) {
                    deserializedL3NetworkProperties.vlan = reader.getLong();
                    continue;
                }
                if ("associatedResourceIds".equals(fieldName)) {
                    List associatedResourceIds;
                    deserializedL3NetworkProperties.associatedResourceIds = associatedResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedL3NetworkProperties.clusterId = reader.getString();
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedL3NetworkProperties.detailedStatus = L3NetworkDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedL3NetworkProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("hybridAksClustersAssociatedIds".equals(fieldName)) {
                    List hybridAksClustersAssociatedIds;
                    deserializedL3NetworkProperties.hybridAksClustersAssociatedIds = hybridAksClustersAssociatedIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("hybridAksIpamEnabled".equals(fieldName)) {
                    deserializedL3NetworkProperties.hybridAksIpamEnabled = HybridAksIpamEnabled.fromString(reader.getString());
                    continue;
                }
                if ("hybridAksPluginType".equals(fieldName)) {
                    deserializedL3NetworkProperties.hybridAksPluginType = HybridAksPluginType.fromString(reader.getString());
                    continue;
                }
                if ("interfaceName".equals(fieldName)) {
                    deserializedL3NetworkProperties.interfaceName = reader.getString();
                    continue;
                }
                if ("ipAllocationType".equals(fieldName)) {
                    deserializedL3NetworkProperties.ipAllocationType = IpAllocationType.fromString(reader.getString());
                    continue;
                }
                if ("ipv4ConnectedPrefix".equals(fieldName)) {
                    deserializedL3NetworkProperties.ipv4ConnectedPrefix = reader.getString();
                    continue;
                }
                if ("ipv6ConnectedPrefix".equals(fieldName)) {
                    deserializedL3NetworkProperties.ipv6ConnectedPrefix = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedL3NetworkProperties.provisioningState = L3NetworkProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("virtualMachinesAssociatedIds".equals(fieldName)) {
                    List virtualMachinesAssociatedIds;
                    deserializedL3NetworkProperties.virtualMachinesAssociatedIds = virtualMachinesAssociatedIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedL3NetworkProperties;
        });
    }
}

