/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterProperties;
import com.azure.resourcemanager.networkcloud.models.AadConfiguration;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfiguration;
import com.azure.resourcemanager.networkcloud.models.AvailableUpgrade;
import com.azure.resourcemanager.networkcloud.models.ControlPlaneNodeConfiguration;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.FeatureStatus;
import com.azure.resourcemanager.networkcloud.models.InitialAgentPoolConfiguration;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterNode;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import com.azure.resourcemanager.networkcloud.models.NetworkConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class KubernetesClusterInner
extends Resource {
    private String etag;
    private ExtendedLocation extendedLocation;
    private KubernetesClusterProperties innerProperties = new KubernetesClusterProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(KubernetesClusterInner.class);

    public String etag() {
        return this.etag;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public KubernetesClusterInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private KubernetesClusterProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public KubernetesClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public KubernetesClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public AadConfiguration aadConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().aadConfiguration();
    }

    public KubernetesClusterInner withAadConfiguration(AadConfiguration aadConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterProperties();
        }
        this.innerProperties().withAadConfiguration(aadConfiguration);
        return this;
    }

    public AdministratorConfiguration administratorConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorConfiguration();
    }

    public KubernetesClusterInner withAdministratorConfiguration(AdministratorConfiguration administratorConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterProperties();
        }
        this.innerProperties().withAdministratorConfiguration(administratorConfiguration);
        return this;
    }

    public List<String> attachedNetworkIds() {
        return this.innerProperties() == null ? null : this.innerProperties().attachedNetworkIds();
    }

    public List<AvailableUpgrade> availableUpgrades() {
        return this.innerProperties() == null ? null : this.innerProperties().availableUpgrades();
    }

    public String clusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterId();
    }

    public String connectedClusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().connectedClusterId();
    }

    public String controlPlaneKubernetesVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().controlPlaneKubernetesVersion();
    }

    public ControlPlaneNodeConfiguration controlPlaneNodeConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().controlPlaneNodeConfiguration();
    }

    public KubernetesClusterInner withControlPlaneNodeConfiguration(ControlPlaneNodeConfiguration controlPlaneNodeConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterProperties();
        }
        this.innerProperties().withControlPlaneNodeConfiguration(controlPlaneNodeConfiguration);
        return this;
    }

    public KubernetesClusterDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public List<FeatureStatus> featureStatuses() {
        return this.innerProperties() == null ? null : this.innerProperties().featureStatuses();
    }

    public List<InitialAgentPoolConfiguration> initialAgentPoolConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().initialAgentPoolConfigurations();
    }

    public KubernetesClusterInner withInitialAgentPoolConfigurations(List<InitialAgentPoolConfiguration> initialAgentPoolConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterProperties();
        }
        this.innerProperties().withInitialAgentPoolConfigurations(initialAgentPoolConfigurations);
        return this;
    }

    public String kubernetesVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().kubernetesVersion();
    }

    public KubernetesClusterInner withKubernetesVersion(String kubernetesVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterProperties();
        }
        this.innerProperties().withKubernetesVersion(kubernetesVersion);
        return this;
    }

    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().managedResourceGroupConfiguration();
    }

    public KubernetesClusterInner withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration managedResourceGroupConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterProperties();
        }
        this.innerProperties().withManagedResourceGroupConfiguration(managedResourceGroupConfiguration);
        return this;
    }

    public NetworkConfiguration networkConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().networkConfiguration();
    }

    public KubernetesClusterInner withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterProperties();
        }
        this.innerProperties().withNetworkConfiguration(networkConfiguration);
        return this;
    }

    public List<KubernetesClusterNode> nodes() {
        return this.innerProperties() == null ? null : this.innerProperties().nodes();
    }

    public KubernetesClusterProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model KubernetesClusterInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model KubernetesClusterInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterInner fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterInner)((Object)jsonReader.readObject(reader -> {
            KubernetesClusterInner deserializedKubernetesClusterInner = new KubernetesClusterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedKubernetesClusterInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedKubernetesClusterInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedKubernetesClusterInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedKubernetesClusterInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKubernetesClusterInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedKubernetesClusterInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedKubernetesClusterInner.innerProperties = KubernetesClusterProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedKubernetesClusterInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedKubernetesClusterInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterInner;
        }));
    }
}

