/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.VirtualMachineInner;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineList
implements JsonSerializable<VirtualMachineList> {
    private String nextLink;
    private List<VirtualMachineInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public VirtualMachineList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<VirtualMachineInner> value() {
        return this.value;
    }

    public VirtualMachineList withValue(List<VirtualMachineInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineList fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineList)jsonReader.readObject(reader -> {
            VirtualMachineList deserializedVirtualMachineList = new VirtualMachineList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedVirtualMachineList.value = value = reader.readArray(reader1 -> VirtualMachineInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineList;
        });
    }
}

