/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ValidationThresholdGrouping;
import com.azure.resourcemanager.networkcloud.models.ValidationThresholdType;
import java.io.IOException;

public final class ValidationThreshold
implements JsonSerializable<ValidationThreshold> {
    private ValidationThresholdGrouping grouping;
    private ValidationThresholdType type;
    private long value;
    private static final ClientLogger LOGGER = new ClientLogger(ValidationThreshold.class);

    public ValidationThresholdGrouping grouping() {
        return this.grouping;
    }

    public ValidationThreshold withGrouping(ValidationThresholdGrouping grouping) {
        this.grouping = grouping;
        return this;
    }

    public ValidationThresholdType type() {
        return this.type;
    }

    public ValidationThreshold withType(ValidationThresholdType type) {
        this.type = type;
        return this;
    }

    public long value() {
        return this.value;
    }

    public ValidationThreshold withValue(long value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.grouping() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property grouping in model ValidationThreshold"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ValidationThreshold"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("grouping", this.grouping == null ? null : this.grouping.toString());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeLongField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static ValidationThreshold fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationThreshold)jsonReader.readObject(reader -> {
            ValidationThreshold deserializedValidationThreshold = new ValidationThreshold();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("grouping".equals(fieldName)) {
                    deserializedValidationThreshold.grouping = ValidationThresholdGrouping.fromString(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedValidationThreshold.type = ValidationThresholdType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedValidationThreshold.value = reader.getLong();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidationThreshold;
        });
    }
}

