/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.StorageApplianceInner;
import com.azure.resourcemanager.networkcloud.models.AdministrativeCredentials;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.RemoteVendorManagementFeature;
import com.azure.resourcemanager.networkcloud.models.RemoteVendorManagementStatus;
import com.azure.resourcemanager.networkcloud.models.SecretRotationStatus;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceEnableRemoteVendorManagementParameters;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceProvisioningState;
import java.util.List;
import java.util.Map;

public interface StorageAppliance {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public AdministrativeCredentials administratorCredentials();

    public Long capacity();

    public Long capacityUsed();

    public String clusterId();

    public StorageApplianceDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public String managementIpv4Address();

    public String manufacturer();

    public String model();

    public StorageApplianceProvisioningState provisioningState();

    public String rackId();

    public long rackSlot();

    public RemoteVendorManagementFeature remoteVendorManagementFeature();

    public RemoteVendorManagementStatus remoteVendorManagementStatus();

    public List<SecretRotationStatus> secretRotationStatus();

    public String serialNumber();

    public String storageApplianceSkuId();

    public String version();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public StorageApplianceInner innerModel();

    public Update update();

    public StorageAppliance refresh();

    public StorageAppliance refresh(Context var1);

    public OperationStatusResult disableRemoteVendorManagement();

    public OperationStatusResult disableRemoteVendorManagement(Context var1);

    public OperationStatusResult enableRemoteVendorManagement();

    public OperationStatusResult enableRemoteVendorManagement(StorageApplianceEnableRemoteVendorManagementParameters var1, Context var2);

    public static interface UpdateStages {

        public static interface WithSerialNumber {
            public Update withSerialNumber(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithSerialNumber {
        public StorageAppliance apply();

        public StorageAppliance apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags {
            public StorageAppliance create();

            public StorageAppliance create(Context var1);
        }

        public static interface WithStorageApplianceSkuId {
            public WithCreate withStorageApplianceSkuId(String var1);
        }

        public static interface WithSerialNumber {
            public WithStorageApplianceSkuId withSerialNumber(String var1);
        }

        public static interface WithRackSlot {
            public WithSerialNumber withRackSlot(long var1);
        }

        public static interface WithRackId {
            public WithRackSlot withRackId(String var1);
        }

        public static interface WithAdministratorCredentials {
            public WithRackId withAdministratorCredentials(AdministrativeCredentials var1);
        }

        public static interface WithExtendedLocation {
            public WithAdministratorCredentials withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithResourceGroup {
            public WithExtendedLocation withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithAdministratorCredentials,
    DefinitionStages.WithRackId,
    DefinitionStages.WithRackSlot,
    DefinitionStages.WithSerialNumber,
    DefinitionStages.WithStorageApplianceSkuId,
    DefinitionStages.WithCreate {
    }
}

