/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.KubernetesPluginType;
import java.io.IOException;

public final class L2NetworkAttachmentConfiguration
implements JsonSerializable<L2NetworkAttachmentConfiguration> {
    private String networkId;
    private KubernetesPluginType pluginType;
    private static final ClientLogger LOGGER = new ClientLogger(L2NetworkAttachmentConfiguration.class);

    public String networkId() {
        return this.networkId;
    }

    public L2NetworkAttachmentConfiguration withNetworkId(String networkId) {
        this.networkId = networkId;
        return this;
    }

    public KubernetesPluginType pluginType() {
        return this.pluginType;
    }

    public L2NetworkAttachmentConfiguration withPluginType(KubernetesPluginType pluginType) {
        this.pluginType = pluginType;
        return this;
    }

    public void validate() {
        if (this.networkId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkId in model L2NetworkAttachmentConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkId", this.networkId);
        jsonWriter.writeStringField("pluginType", this.pluginType == null ? null : this.pluginType.toString());
        return jsonWriter.writeEndObject();
    }

    public static L2NetworkAttachmentConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (L2NetworkAttachmentConfiguration)jsonReader.readObject(reader -> {
            L2NetworkAttachmentConfiguration deserializedL2NetworkAttachmentConfiguration = new L2NetworkAttachmentConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkId".equals(fieldName)) {
                    deserializedL2NetworkAttachmentConfiguration.networkId = reader.getString();
                    continue;
                }
                if ("pluginType".equals(fieldName)) {
                    deserializedL2NetworkAttachmentConfiguration.pluginType = KubernetesPluginType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedL2NetworkAttachmentConfiguration;
        });
    }
}

