/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public final class ClusterManagerPatchParameters
implements JsonSerializable<ClusterManagerPatchParameters> {
    private ManagedServiceIdentity identity;
    private Map<String, String> tags;

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ClusterManagerPatchParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ClusterManagerPatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ClusterManagerPatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterManagerPatchParameters)jsonReader.readObject(reader -> {
            ClusterManagerPatchParameters deserializedClusterManagerPatchParameters = new ClusterManagerPatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedClusterManagerPatchParameters.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedClusterManagerPatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterManagerPatchParameters;
        });
    }
}

