/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterInner;
import com.azure.resourcemanager.networkcloud.models.AnalyticsOutputSettings;
import com.azure.resourcemanager.networkcloud.models.ClusterAvailableUpgradeVersion;
import com.azure.resourcemanager.networkcloud.models.ClusterCapacity;
import com.azure.resourcemanager.networkcloud.models.ClusterConnectionStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterContinueUpdateVersionParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterDeployParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerConnectionStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ClusterScanRuntimeParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterSecretArchive;
import com.azure.resourcemanager.networkcloud.models.ClusterType;
import com.azure.resourcemanager.networkcloud.models.ClusterUpdateStrategy;
import com.azure.resourcemanager.networkcloud.models.ClusterUpdateVersionParameters;
import com.azure.resourcemanager.networkcloud.models.CommandOutputSettings;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import com.azure.resourcemanager.networkcloud.models.ManagedServiceIdentity;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.RackDefinition;
import com.azure.resourcemanager.networkcloud.models.RuntimeProtectionConfiguration;
import com.azure.resourcemanager.networkcloud.models.SecretArchiveSettings;
import com.azure.resourcemanager.networkcloud.models.ServicePrincipalInformation;
import com.azure.resourcemanager.networkcloud.models.ValidationThreshold;
import com.azure.resourcemanager.networkcloud.models.VulnerabilityScanningSettings;
import com.azure.resourcemanager.networkcloud.models.VulnerabilityScanningSettingsPatch;
import java.util.List;
import java.util.Map;

public interface Cluster {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ExtendedLocation extendedLocation();

    public ManagedServiceIdentity identity();

    public SystemData systemData();

    public RackDefinition aggregatorOrSingleRackDefinition();

    public AnalyticsOutputSettings analyticsOutputSettings();

    public String analyticsWorkspaceId();

    public List<ClusterAvailableUpgradeVersion> availableUpgradeVersions();

    public ClusterCapacity clusterCapacity();

    public ClusterConnectionStatus clusterConnectionStatus();

    public ExtendedLocation clusterExtendedLocation();

    public String clusterLocation();

    public ClusterManagerConnectionStatus clusterManagerConnectionStatus();

    public String clusterManagerId();

    public ServicePrincipalInformation clusterServicePrincipal();

    public ClusterType clusterType();

    public String clusterVersion();

    public CommandOutputSettings commandOutputSettings();

    public ValidationThreshold computeDeploymentThreshold();

    public List<RackDefinition> computeRackDefinitions();

    public ClusterDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public ExtendedLocation hybridAksExtendedLocation();

    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration();

    public Long manualActionCount();

    public String networkFabricId();

    public ClusterProvisioningState provisioningState();

    public RuntimeProtectionConfiguration runtimeProtectionConfiguration();

    public ClusterSecretArchive secretArchive();

    public SecretArchiveSettings secretArchiveSettings();

    public String supportExpiryDate();

    public ClusterUpdateStrategy updateStrategy();

    public VulnerabilityScanningSettings vulnerabilityScanningSettings();

    public List<String> workloadResourceIds();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ClusterInner innerModel();

    public Update update();

    public Cluster refresh();

    public Cluster refresh(Context var1);

    public OperationStatusResult continueUpdateVersion(ClusterContinueUpdateVersionParameters var1);

    public OperationStatusResult continueUpdateVersion(ClusterContinueUpdateVersionParameters var1, Context var2);

    public OperationStatusResult deploy();

    public OperationStatusResult deploy(ClusterDeployParameters var1, Context var2);

    public OperationStatusResult scanRuntime();

    public OperationStatusResult scanRuntime(ClusterScanRuntimeParameters var1, Context var2);

    public OperationStatusResult updateVersion(ClusterUpdateVersionParameters var1);

    public OperationStatusResult updateVersion(ClusterUpdateVersionParameters var1, Context var2);

    public static interface UpdateStages {

        public static interface WithVulnerabilityScanningSettings {
            public Update withVulnerabilityScanningSettings(VulnerabilityScanningSettingsPatch var1);
        }

        public static interface WithUpdateStrategy {
            public Update withUpdateStrategy(ClusterUpdateStrategy var1);
        }

        public static interface WithSecretArchiveSettings {
            public Update withSecretArchiveSettings(SecretArchiveSettings var1);
        }

        public static interface WithSecretArchive {
            public Update withSecretArchive(ClusterSecretArchive var1);
        }

        public static interface WithRuntimeProtectionConfiguration {
            public Update withRuntimeProtectionConfiguration(RuntimeProtectionConfiguration var1);
        }

        public static interface WithComputeRackDefinitions {
            public Update withComputeRackDefinitions(List<RackDefinition> var1);
        }

        public static interface WithComputeDeploymentThreshold {
            public Update withComputeDeploymentThreshold(ValidationThreshold var1);
        }

        public static interface WithCommandOutputSettings {
            public Update withCommandOutputSettings(CommandOutputSettings var1);
        }

        public static interface WithClusterServicePrincipal {
            public Update withClusterServicePrincipal(ServicePrincipalInformation var1);
        }

        public static interface WithClusterLocation {
            public Update withClusterLocation(String var1);
        }

        public static interface WithAnalyticsOutputSettings {
            public Update withAnalyticsOutputSettings(AnalyticsOutputSettings var1);
        }

        public static interface WithAggregatorOrSingleRackDefinition {
            public Update withAggregatorOrSingleRackDefinition(RackDefinition var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithAggregatorOrSingleRackDefinition,
    UpdateStages.WithAnalyticsOutputSettings,
    UpdateStages.WithClusterLocation,
    UpdateStages.WithClusterServicePrincipal,
    UpdateStages.WithCommandOutputSettings,
    UpdateStages.WithComputeDeploymentThreshold,
    UpdateStages.WithComputeRackDefinitions,
    UpdateStages.WithRuntimeProtectionConfiguration,
    UpdateStages.WithSecretArchive,
    UpdateStages.WithSecretArchiveSettings,
    UpdateStages.WithUpdateStrategy,
    UpdateStages.WithVulnerabilityScanningSettings {
        public Cluster apply();

        public Cluster apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithVulnerabilityScanningSettings {
            public WithCreate withVulnerabilityScanningSettings(VulnerabilityScanningSettings var1);
        }

        public static interface WithUpdateStrategy {
            public WithCreate withUpdateStrategy(ClusterUpdateStrategy var1);
        }

        public static interface WithSecretArchiveSettings {
            public WithCreate withSecretArchiveSettings(SecretArchiveSettings var1);
        }

        public static interface WithSecretArchive {
            public WithCreate withSecretArchive(ClusterSecretArchive var1);
        }

        public static interface WithRuntimeProtectionConfiguration {
            public WithCreate withRuntimeProtectionConfiguration(RuntimeProtectionConfiguration var1);
        }

        public static interface WithManagedResourceGroupConfiguration {
            public WithCreate withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration var1);
        }

        public static interface WithComputeRackDefinitions {
            public WithCreate withComputeRackDefinitions(List<RackDefinition> var1);
        }

        public static interface WithComputeDeploymentThreshold {
            public WithCreate withComputeDeploymentThreshold(ValidationThreshold var1);
        }

        public static interface WithCommandOutputSettings {
            public WithCreate withCommandOutputSettings(CommandOutputSettings var1);
        }

        public static interface WithClusterServicePrincipal {
            public WithCreate withClusterServicePrincipal(ServicePrincipalInformation var1);
        }

        public static interface WithClusterLocation {
            public WithCreate withClusterLocation(String var1);
        }

        public static interface WithAnalyticsWorkspaceId {
            public WithCreate withAnalyticsWorkspaceId(String var1);
        }

        public static interface WithAnalyticsOutputSettings {
            public WithCreate withAnalyticsOutputSettings(AnalyticsOutputSettings var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ManagedServiceIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithAnalyticsOutputSettings,
        WithAnalyticsWorkspaceId,
        WithClusterLocation,
        WithClusterServicePrincipal,
        WithCommandOutputSettings,
        WithComputeDeploymentThreshold,
        WithComputeRackDefinitions,
        WithManagedResourceGroupConfiguration,
        WithRuntimeProtectionConfiguration,
        WithSecretArchive,
        WithSecretArchiveSettings,
        WithUpdateStrategy,
        WithVulnerabilityScanningSettings {
            public Cluster create();

            public Cluster create(Context var1);
        }

        public static interface WithNetworkFabricId {
            public WithCreate withNetworkFabricId(String var1);
        }

        public static interface WithClusterVersion {
            public WithNetworkFabricId withClusterVersion(String var1);
        }

        public static interface WithClusterType {
            public WithClusterVersion withClusterType(ClusterType var1);
        }

        public static interface WithAggregatorOrSingleRackDefinition {
            public WithClusterType withAggregatorOrSingleRackDefinition(RackDefinition var1);
        }

        public static interface WithExtendedLocation {
            public WithAggregatorOrSingleRackDefinition withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithResourceGroup {
            public WithExtendedLocation withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithAggregatorOrSingleRackDefinition,
    DefinitionStages.WithClusterType,
    DefinitionStages.WithClusterVersion,
    DefinitionStages.WithNetworkFabricId,
    DefinitionStages.WithCreate {
    }
}

