/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AdministrativeCredentials;
import java.io.IOException;

public final class BareMetalMachineConfigurationData
implements JsonSerializable<BareMetalMachineConfigurationData> {
    private String bmcConnectionString;
    private AdministrativeCredentials bmcCredentials;
    private String bmcMacAddress;
    private String bootMacAddress;
    private String machineDetails;
    private String machineName;
    private long rackSlot;
    private String serialNumber;
    private static final ClientLogger LOGGER = new ClientLogger(BareMetalMachineConfigurationData.class);

    public String bmcConnectionString() {
        return this.bmcConnectionString;
    }

    public AdministrativeCredentials bmcCredentials() {
        return this.bmcCredentials;
    }

    public BareMetalMachineConfigurationData withBmcCredentials(AdministrativeCredentials bmcCredentials) {
        this.bmcCredentials = bmcCredentials;
        return this;
    }

    public String bmcMacAddress() {
        return this.bmcMacAddress;
    }

    public BareMetalMachineConfigurationData withBmcMacAddress(String bmcMacAddress) {
        this.bmcMacAddress = bmcMacAddress;
        return this;
    }

    public String bootMacAddress() {
        return this.bootMacAddress;
    }

    public BareMetalMachineConfigurationData withBootMacAddress(String bootMacAddress) {
        this.bootMacAddress = bootMacAddress;
        return this;
    }

    public String machineDetails() {
        return this.machineDetails;
    }

    public BareMetalMachineConfigurationData withMachineDetails(String machineDetails) {
        this.machineDetails = machineDetails;
        return this;
    }

    public String machineName() {
        return this.machineName;
    }

    public BareMetalMachineConfigurationData withMachineName(String machineName) {
        this.machineName = machineName;
        return this;
    }

    public long rackSlot() {
        return this.rackSlot;
    }

    public BareMetalMachineConfigurationData withRackSlot(long rackSlot) {
        this.rackSlot = rackSlot;
        return this;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public BareMetalMachineConfigurationData withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public void validate() {
        if (this.bmcCredentials() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bmcCredentials in model BareMetalMachineConfigurationData"));
        }
        this.bmcCredentials().validate();
        if (this.bmcMacAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bmcMacAddress in model BareMetalMachineConfigurationData"));
        }
        if (this.bootMacAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property bootMacAddress in model BareMetalMachineConfigurationData"));
        }
        if (this.serialNumber() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serialNumber in model BareMetalMachineConfigurationData"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("bmcCredentials", (JsonSerializable)this.bmcCredentials);
        jsonWriter.writeStringField("bmcMacAddress", this.bmcMacAddress);
        jsonWriter.writeStringField("bootMacAddress", this.bootMacAddress);
        jsonWriter.writeLongField("rackSlot", this.rackSlot);
        jsonWriter.writeStringField("serialNumber", this.serialNumber);
        jsonWriter.writeStringField("machineDetails", this.machineDetails);
        jsonWriter.writeStringField("machineName", this.machineName);
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachineConfigurationData fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachineConfigurationData)jsonReader.readObject(reader -> {
            BareMetalMachineConfigurationData deserializedBareMetalMachineConfigurationData = new BareMetalMachineConfigurationData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bmcCredentials".equals(fieldName)) {
                    deserializedBareMetalMachineConfigurationData.bmcCredentials = AdministrativeCredentials.fromJson(reader);
                    continue;
                }
                if ("bmcMacAddress".equals(fieldName)) {
                    deserializedBareMetalMachineConfigurationData.bmcMacAddress = reader.getString();
                    continue;
                }
                if ("bootMacAddress".equals(fieldName)) {
                    deserializedBareMetalMachineConfigurationData.bootMacAddress = reader.getString();
                    continue;
                }
                if ("rackSlot".equals(fieldName)) {
                    deserializedBareMetalMachineConfigurationData.rackSlot = reader.getLong();
                    continue;
                }
                if ("serialNumber".equals(fieldName)) {
                    deserializedBareMetalMachineConfigurationData.serialNumber = reader.getString();
                    continue;
                }
                if ("bmcConnectionString".equals(fieldName)) {
                    deserializedBareMetalMachineConfigurationData.bmcConnectionString = reader.getString();
                    continue;
                }
                if ("machineDetails".equals(fieldName)) {
                    deserializedBareMetalMachineConfigurationData.machineDetails = reader.getString();
                    continue;
                }
                if ("machineName".equals(fieldName)) {
                    deserializedBareMetalMachineConfigurationData.machineName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachineConfigurationData;
        });
    }
}

