/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.L2NetworksClient;
import com.azure.resourcemanager.networkcloud.fluent.models.L2NetworkInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.L2NetworkImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.L2Network;
import com.azure.resourcemanager.networkcloud.models.L2Networks;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class L2NetworksImpl
implements L2Networks {
    private static final ClientLogger LOGGER = new ClientLogger(L2NetworksImpl.class);
    private final L2NetworksClient innerClient;
    private final NetworkCloudManager serviceManager;

    public L2NetworksImpl(L2NetworksClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<L2Network> list() {
        PagedIterable<L2NetworkInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new L2NetworkImpl((L2NetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<L2Network> list(Context context) {
        PagedIterable<L2NetworkInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new L2NetworkImpl((L2NetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<L2Network> listByResourceGroup(String resourceGroupName) {
        PagedIterable<L2NetworkInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new L2NetworkImpl((L2NetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<L2Network> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<L2NetworkInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new L2NetworkImpl((L2NetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<L2Network> getByResourceGroupWithResponse(String resourceGroupName, String l2NetworkName, Context context) {
        Response<L2NetworkInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, l2NetworkName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new L2NetworkImpl((L2NetworkInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public L2Network getByResourceGroup(String resourceGroupName, String l2NetworkName) {
        L2NetworkInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, l2NetworkName);
        if (inner != null) {
            return new L2NetworkImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String l2NetworkName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, l2NetworkName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String l2NetworkName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, l2NetworkName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public L2Network getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String l2NetworkName = ResourceManagerUtils.getValueFromIdByName(id, "l2Networks");
        if (l2NetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'l2Networks'.", id)));
        }
        return (L2Network)this.getByResourceGroupWithResponse(resourceGroupName, l2NetworkName, Context.NONE).getValue();
    }

    @Override
    public Response<L2Network> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String l2NetworkName = ResourceManagerUtils.getValueFromIdByName(id, "l2Networks");
        if (l2NetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'l2Networks'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, l2NetworkName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String l2NetworkName = ResourceManagerUtils.getValueFromIdByName(id, "l2Networks");
        if (l2NetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'l2Networks'.", id)));
        }
        return this.delete(resourceGroupName, l2NetworkName, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String l2NetworkName = ResourceManagerUtils.getValueFromIdByName(id, "l2Networks");
        if (l2NetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'l2Networks'.", id)));
        }
        return this.delete(resourceGroupName, l2NetworkName, context);
    }

    private L2NetworksClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public L2NetworkImpl define(String name) {
        return new L2NetworkImpl(name, this.manager());
    }
}

