/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.KubernetesClusterFeaturesClient;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterFeatureInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.KubernetesClusterFeatureImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeature;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatures;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class KubernetesClusterFeaturesImpl
implements KubernetesClusterFeatures {
    private static final ClientLogger LOGGER = new ClientLogger(KubernetesClusterFeaturesImpl.class);
    private final KubernetesClusterFeaturesClient innerClient;
    private final NetworkCloudManager serviceManager;

    public KubernetesClusterFeaturesImpl(KubernetesClusterFeaturesClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<KubernetesClusterFeature> listByKubernetesCluster(String resourceGroupName, String kubernetesClusterName) {
        PagedIterable<KubernetesClusterFeatureInner> inner = this.serviceClient().listByKubernetesCluster(resourceGroupName, kubernetesClusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new KubernetesClusterFeatureImpl((KubernetesClusterFeatureInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<KubernetesClusterFeature> listByKubernetesCluster(String resourceGroupName, String kubernetesClusterName, Context context) {
        PagedIterable<KubernetesClusterFeatureInner> inner = this.serviceClient().listByKubernetesCluster(resourceGroupName, kubernetesClusterName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new KubernetesClusterFeatureImpl((KubernetesClusterFeatureInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<KubernetesClusterFeature> getWithResponse(String resourceGroupName, String kubernetesClusterName, String featureName, Context context) {
        Response<KubernetesClusterFeatureInner> inner = this.serviceClient().getWithResponse(resourceGroupName, kubernetesClusterName, featureName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new KubernetesClusterFeatureImpl((KubernetesClusterFeatureInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public KubernetesClusterFeature get(String resourceGroupName, String kubernetesClusterName, String featureName) {
        KubernetesClusterFeatureInner inner = this.serviceClient().get(resourceGroupName, kubernetesClusterName, featureName);
        if (inner != null) {
            return new KubernetesClusterFeatureImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String kubernetesClusterName, String featureName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, kubernetesClusterName, featureName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String kubernetesClusterName, String featureName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, kubernetesClusterName, featureName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public KubernetesClusterFeature getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        String featureName = ResourceManagerUtils.getValueFromIdByName(id, "features");
        if (featureName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'features'.", id)));
        }
        return (KubernetesClusterFeature)this.getWithResponse(resourceGroupName, kubernetesClusterName, featureName, Context.NONE).getValue();
    }

    @Override
    public Response<KubernetesClusterFeature> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        String featureName = ResourceManagerUtils.getValueFromIdByName(id, "features");
        if (featureName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'features'.", id)));
        }
        return this.getWithResponse(resourceGroupName, kubernetesClusterName, featureName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        String featureName = ResourceManagerUtils.getValueFromIdByName(id, "features");
        if (featureName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'features'.", id)));
        }
        return this.delete(resourceGroupName, kubernetesClusterName, featureName, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        String featureName = ResourceManagerUtils.getValueFromIdByName(id, "features");
        if (featureName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'features'.", id)));
        }
        return this.delete(resourceGroupName, kubernetesClusterName, featureName, context);
    }

    private KubernetesClusterFeaturesClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public KubernetesClusterFeatureImpl define(String name) {
        return new KubernetesClusterFeatureImpl(name, this.manager());
    }
}

