/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineKeySetInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySet;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetPatchParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetPrivilegeLevel;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.KeySetUser;
import com.azure.resourcemanager.networkcloud.models.KeySetUserStatus;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class BareMetalMachineKeySetImpl
implements BareMetalMachineKeySet,
BareMetalMachineKeySet.Definition,
BareMetalMachineKeySet.Update {
    private BareMetalMachineKeySetInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String bareMetalMachineKeySetName;
    private BareMetalMachineKeySetPatchParameters updateBareMetalMachineKeySetUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String azureGroupId() {
        return this.innerModel().azureGroupId();
    }

    @Override
    public BareMetalMachineKeySetDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public OffsetDateTime expiration() {
        return this.innerModel().expiration();
    }

    @Override
    public List<String> jumpHostsAllowed() {
        List<String> inner = this.innerModel().jumpHostsAllowed();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public OffsetDateTime lastValidation() {
        return this.innerModel().lastValidation();
    }

    @Override
    public String osGroupName() {
        return this.innerModel().osGroupName();
    }

    @Override
    public BareMetalMachineKeySetPrivilegeLevel privilegeLevel() {
        return this.innerModel().privilegeLevel();
    }

    @Override
    public BareMetalMachineKeySetProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<KeySetUser> userList() {
        List<KeySetUser> inner = this.innerModel().userList();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<KeySetUserStatus> userListStatus() {
        List<KeySetUserStatus> inner = this.innerModel().userListStatus();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BareMetalMachineKeySetInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public BareMetalMachineKeySetImpl withExistingCluster(String resourceGroupName, String clusterName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public BareMetalMachineKeySet create() {
        this.innerObject = this.serviceManager.serviceClient().getBareMetalMachineKeySets().createOrUpdate(this.resourceGroupName, this.clusterName, this.bareMetalMachineKeySetName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public BareMetalMachineKeySet create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBareMetalMachineKeySets().createOrUpdate(this.resourceGroupName, this.clusterName, this.bareMetalMachineKeySetName, this.innerModel(), context);
        return this;
    }

    BareMetalMachineKeySetImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new BareMetalMachineKeySetInner();
        this.serviceManager = serviceManager;
        this.bareMetalMachineKeySetName = name;
    }

    @Override
    public BareMetalMachineKeySetImpl update() {
        this.updateBareMetalMachineKeySetUpdateParameters = new BareMetalMachineKeySetPatchParameters();
        return this;
    }

    @Override
    public BareMetalMachineKeySet apply() {
        this.innerObject = this.serviceManager.serviceClient().getBareMetalMachineKeySets().update(this.resourceGroupName, this.clusterName, this.bareMetalMachineKeySetName, this.updateBareMetalMachineKeySetUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public BareMetalMachineKeySet apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBareMetalMachineKeySets().update(this.resourceGroupName, this.clusterName, this.bareMetalMachineKeySetName, this.updateBareMetalMachineKeySetUpdateParameters, context);
        return this;
    }

    BareMetalMachineKeySetImpl(BareMetalMachineKeySetInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "clusters");
        this.bareMetalMachineKeySetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "bareMetalMachineKeySets");
    }

    @Override
    public BareMetalMachineKeySet refresh() {
        this.innerObject = (BareMetalMachineKeySetInner)((Object)this.serviceManager.serviceClient().getBareMetalMachineKeySets().getWithResponse(this.resourceGroupName, this.clusterName, this.bareMetalMachineKeySetName, Context.NONE).getValue());
        return this;
    }

    @Override
    public BareMetalMachineKeySet refresh(Context context) {
        this.innerObject = (BareMetalMachineKeySetInner)((Object)this.serviceManager.serviceClient().getBareMetalMachineKeySets().getWithResponse(this.resourceGroupName, this.clusterName, this.bareMetalMachineKeySetName, context).getValue());
        return this;
    }

    @Override
    public BareMetalMachineKeySetImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public BareMetalMachineKeySetImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public BareMetalMachineKeySetImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public BareMetalMachineKeySetImpl withAzureGroupId(String azureGroupId) {
        this.innerModel().withAzureGroupId(azureGroupId);
        return this;
    }

    @Override
    public BareMetalMachineKeySetImpl withExpiration(OffsetDateTime expiration) {
        if (this.isInCreateMode()) {
            this.innerModel().withExpiration(expiration);
            return this;
        }
        this.updateBareMetalMachineKeySetUpdateParameters.withExpiration(expiration);
        return this;
    }

    @Override
    public BareMetalMachineKeySetImpl withJumpHostsAllowed(List<String> jumpHostsAllowed) {
        if (this.isInCreateMode()) {
            this.innerModel().withJumpHostsAllowed(jumpHostsAllowed);
            return this;
        }
        this.updateBareMetalMachineKeySetUpdateParameters.withJumpHostsAllowed(jumpHostsAllowed);
        return this;
    }

    @Override
    public BareMetalMachineKeySetImpl withPrivilegeLevel(BareMetalMachineKeySetPrivilegeLevel privilegeLevel) {
        this.innerModel().withPrivilegeLevel(privilegeLevel);
        return this;
    }

    @Override
    public BareMetalMachineKeySetImpl withUserList(List<KeySetUser> userList) {
        if (this.isInCreateMode()) {
            this.innerModel().withUserList(userList);
            return this;
        }
        this.updateBareMetalMachineKeySetUpdateParameters.withUserList(userList);
        return this;
    }

    @Override
    public BareMetalMachineKeySetImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBareMetalMachineKeySetUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public BareMetalMachineKeySetImpl withOsGroupName(String osGroupName) {
        this.innerModel().withOsGroupName(osGroupName);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

