/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AnalyticsOutputSettings;
import com.azure.resourcemanager.networkcloud.models.ClusterAvailableUpgradeVersion;
import com.azure.resourcemanager.networkcloud.models.ClusterCapacity;
import com.azure.resourcemanager.networkcloud.models.ClusterConnectionStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerConnectionStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ClusterSecretArchive;
import com.azure.resourcemanager.networkcloud.models.ClusterType;
import com.azure.resourcemanager.networkcloud.models.ClusterUpdateStrategy;
import com.azure.resourcemanager.networkcloud.models.CommandOutputSettings;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import com.azure.resourcemanager.networkcloud.models.RackDefinition;
import com.azure.resourcemanager.networkcloud.models.RuntimeProtectionConfiguration;
import com.azure.resourcemanager.networkcloud.models.SecretArchiveSettings;
import com.azure.resourcemanager.networkcloud.models.ServicePrincipalInformation;
import com.azure.resourcemanager.networkcloud.models.ValidationThreshold;
import com.azure.resourcemanager.networkcloud.models.VulnerabilityScanningSettings;
import java.io.IOException;
import java.util.List;

public final class ClusterProperties
implements JsonSerializable<ClusterProperties> {
    private RackDefinition aggregatorOrSingleRackDefinition;
    private AnalyticsOutputSettings analyticsOutputSettings;
    private String analyticsWorkspaceId;
    private List<ClusterAvailableUpgradeVersion> availableUpgradeVersions;
    private ClusterCapacity clusterCapacity;
    private ClusterConnectionStatus clusterConnectionStatus;
    private ExtendedLocation clusterExtendedLocation;
    private String clusterLocation;
    private ClusterManagerConnectionStatus clusterManagerConnectionStatus;
    private String clusterManagerId;
    private ServicePrincipalInformation clusterServicePrincipal;
    private ClusterType clusterType;
    private String clusterVersion;
    private CommandOutputSettings commandOutputSettings;
    private ValidationThreshold computeDeploymentThreshold;
    private List<RackDefinition> computeRackDefinitions;
    private ClusterDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private ExtendedLocation hybridAksExtendedLocation;
    private ManagedResourceGroupConfiguration managedResourceGroupConfiguration;
    private Long manualActionCount;
    private String networkFabricId;
    private ClusterProvisioningState provisioningState;
    private RuntimeProtectionConfiguration runtimeProtectionConfiguration;
    private ClusterSecretArchive secretArchive;
    private SecretArchiveSettings secretArchiveSettings;
    private String supportExpiryDate;
    private ClusterUpdateStrategy updateStrategy;
    private VulnerabilityScanningSettings vulnerabilityScanningSettings;
    private List<String> workloadResourceIds;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterProperties.class);

    public RackDefinition aggregatorOrSingleRackDefinition() {
        return this.aggregatorOrSingleRackDefinition;
    }

    public ClusterProperties withAggregatorOrSingleRackDefinition(RackDefinition aggregatorOrSingleRackDefinition) {
        this.aggregatorOrSingleRackDefinition = aggregatorOrSingleRackDefinition;
        return this;
    }

    public AnalyticsOutputSettings analyticsOutputSettings() {
        return this.analyticsOutputSettings;
    }

    public ClusterProperties withAnalyticsOutputSettings(AnalyticsOutputSettings analyticsOutputSettings) {
        this.analyticsOutputSettings = analyticsOutputSettings;
        return this;
    }

    public String analyticsWorkspaceId() {
        return this.analyticsWorkspaceId;
    }

    public ClusterProperties withAnalyticsWorkspaceId(String analyticsWorkspaceId) {
        this.analyticsWorkspaceId = analyticsWorkspaceId;
        return this;
    }

    public List<ClusterAvailableUpgradeVersion> availableUpgradeVersions() {
        return this.availableUpgradeVersions;
    }

    public ClusterCapacity clusterCapacity() {
        return this.clusterCapacity;
    }

    public ClusterConnectionStatus clusterConnectionStatus() {
        return this.clusterConnectionStatus;
    }

    public ExtendedLocation clusterExtendedLocation() {
        return this.clusterExtendedLocation;
    }

    public String clusterLocation() {
        return this.clusterLocation;
    }

    public ClusterProperties withClusterLocation(String clusterLocation) {
        this.clusterLocation = clusterLocation;
        return this;
    }

    public ClusterManagerConnectionStatus clusterManagerConnectionStatus() {
        return this.clusterManagerConnectionStatus;
    }

    public String clusterManagerId() {
        return this.clusterManagerId;
    }

    public ServicePrincipalInformation clusterServicePrincipal() {
        return this.clusterServicePrincipal;
    }

    public ClusterProperties withClusterServicePrincipal(ServicePrincipalInformation clusterServicePrincipal) {
        this.clusterServicePrincipal = clusterServicePrincipal;
        return this;
    }

    public ClusterType clusterType() {
        return this.clusterType;
    }

    public ClusterProperties withClusterType(ClusterType clusterType) {
        this.clusterType = clusterType;
        return this;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public ClusterProperties withClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
        return this;
    }

    public CommandOutputSettings commandOutputSettings() {
        return this.commandOutputSettings;
    }

    public ClusterProperties withCommandOutputSettings(CommandOutputSettings commandOutputSettings) {
        this.commandOutputSettings = commandOutputSettings;
        return this;
    }

    public ValidationThreshold computeDeploymentThreshold() {
        return this.computeDeploymentThreshold;
    }

    public ClusterProperties withComputeDeploymentThreshold(ValidationThreshold computeDeploymentThreshold) {
        this.computeDeploymentThreshold = computeDeploymentThreshold;
        return this;
    }

    public List<RackDefinition> computeRackDefinitions() {
        return this.computeRackDefinitions;
    }

    public ClusterProperties withComputeRackDefinitions(List<RackDefinition> computeRackDefinitions) {
        this.computeRackDefinitions = computeRackDefinitions;
        return this;
    }

    public ClusterDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public ExtendedLocation hybridAksExtendedLocation() {
        return this.hybridAksExtendedLocation;
    }

    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration() {
        return this.managedResourceGroupConfiguration;
    }

    public ClusterProperties withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration managedResourceGroupConfiguration) {
        this.managedResourceGroupConfiguration = managedResourceGroupConfiguration;
        return this;
    }

    public Long manualActionCount() {
        return this.manualActionCount;
    }

    public String networkFabricId() {
        return this.networkFabricId;
    }

    public ClusterProperties withNetworkFabricId(String networkFabricId) {
        this.networkFabricId = networkFabricId;
        return this;
    }

    public ClusterProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public RuntimeProtectionConfiguration runtimeProtectionConfiguration() {
        return this.runtimeProtectionConfiguration;
    }

    public ClusterProperties withRuntimeProtectionConfiguration(RuntimeProtectionConfiguration runtimeProtectionConfiguration) {
        this.runtimeProtectionConfiguration = runtimeProtectionConfiguration;
        return this;
    }

    public ClusterSecretArchive secretArchive() {
        return this.secretArchive;
    }

    public ClusterProperties withSecretArchive(ClusterSecretArchive secretArchive) {
        this.secretArchive = secretArchive;
        return this;
    }

    public SecretArchiveSettings secretArchiveSettings() {
        return this.secretArchiveSettings;
    }

    public ClusterProperties withSecretArchiveSettings(SecretArchiveSettings secretArchiveSettings) {
        this.secretArchiveSettings = secretArchiveSettings;
        return this;
    }

    public String supportExpiryDate() {
        return this.supportExpiryDate;
    }

    public ClusterUpdateStrategy updateStrategy() {
        return this.updateStrategy;
    }

    public ClusterProperties withUpdateStrategy(ClusterUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
        return this;
    }

    public VulnerabilityScanningSettings vulnerabilityScanningSettings() {
        return this.vulnerabilityScanningSettings;
    }

    public ClusterProperties withVulnerabilityScanningSettings(VulnerabilityScanningSettings vulnerabilityScanningSettings) {
        this.vulnerabilityScanningSettings = vulnerabilityScanningSettings;
        return this;
    }

    public List<String> workloadResourceIds() {
        return this.workloadResourceIds;
    }

    public void validate() {
        if (this.aggregatorOrSingleRackDefinition() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property aggregatorOrSingleRackDefinition in model ClusterProperties"));
        }
        this.aggregatorOrSingleRackDefinition().validate();
        if (this.analyticsOutputSettings() != null) {
            this.analyticsOutputSettings().validate();
        }
        if (this.availableUpgradeVersions() != null) {
            this.availableUpgradeVersions().forEach(e -> e.validate());
        }
        if (this.clusterCapacity() != null) {
            this.clusterCapacity().validate();
        }
        if (this.clusterExtendedLocation() != null) {
            this.clusterExtendedLocation().validate();
        }
        if (this.clusterServicePrincipal() != null) {
            this.clusterServicePrincipal().validate();
        }
        if (this.clusterType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clusterType in model ClusterProperties"));
        }
        if (this.clusterVersion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clusterVersion in model ClusterProperties"));
        }
        if (this.commandOutputSettings() != null) {
            this.commandOutputSettings().validate();
        }
        if (this.computeDeploymentThreshold() != null) {
            this.computeDeploymentThreshold().validate();
        }
        if (this.computeRackDefinitions() != null) {
            this.computeRackDefinitions().forEach(e -> e.validate());
        }
        if (this.hybridAksExtendedLocation() != null) {
            this.hybridAksExtendedLocation().validate();
        }
        if (this.managedResourceGroupConfiguration() != null) {
            this.managedResourceGroupConfiguration().validate();
        }
        if (this.networkFabricId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkFabricId in model ClusterProperties"));
        }
        if (this.runtimeProtectionConfiguration() != null) {
            this.runtimeProtectionConfiguration().validate();
        }
        if (this.secretArchive() != null) {
            this.secretArchive().validate();
        }
        if (this.secretArchiveSettings() != null) {
            this.secretArchiveSettings().validate();
        }
        if (this.updateStrategy() != null) {
            this.updateStrategy().validate();
        }
        if (this.vulnerabilityScanningSettings() != null) {
            this.vulnerabilityScanningSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("aggregatorOrSingleRackDefinition", (JsonSerializable)this.aggregatorOrSingleRackDefinition);
        jsonWriter.writeStringField("clusterType", this.clusterType == null ? null : this.clusterType.toString());
        jsonWriter.writeStringField("clusterVersion", this.clusterVersion);
        jsonWriter.writeStringField("networkFabricId", this.networkFabricId);
        jsonWriter.writeJsonField("analyticsOutputSettings", (JsonSerializable)this.analyticsOutputSettings);
        jsonWriter.writeStringField("analyticsWorkspaceId", this.analyticsWorkspaceId);
        jsonWriter.writeStringField("clusterLocation", this.clusterLocation);
        jsonWriter.writeJsonField("clusterServicePrincipal", (JsonSerializable)this.clusterServicePrincipal);
        jsonWriter.writeJsonField("commandOutputSettings", (JsonSerializable)this.commandOutputSettings);
        jsonWriter.writeJsonField("computeDeploymentThreshold", (JsonSerializable)this.computeDeploymentThreshold);
        jsonWriter.writeArrayField("computeRackDefinitions", this.computeRackDefinitions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("managedResourceGroupConfiguration", (JsonSerializable)this.managedResourceGroupConfiguration);
        jsonWriter.writeJsonField("runtimeProtectionConfiguration", (JsonSerializable)this.runtimeProtectionConfiguration);
        jsonWriter.writeJsonField("secretArchive", (JsonSerializable)this.secretArchive);
        jsonWriter.writeJsonField("secretArchiveSettings", (JsonSerializable)this.secretArchiveSettings);
        jsonWriter.writeJsonField("updateStrategy", (JsonSerializable)this.updateStrategy);
        jsonWriter.writeJsonField("vulnerabilityScanningSettings", (JsonSerializable)this.vulnerabilityScanningSettings);
        return jsonWriter.writeEndObject();
    }

    public static ClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterProperties)jsonReader.readObject(reader -> {
            ClusterProperties deserializedClusterProperties = new ClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("aggregatorOrSingleRackDefinition".equals(fieldName)) {
                    deserializedClusterProperties.aggregatorOrSingleRackDefinition = RackDefinition.fromJson(reader);
                    continue;
                }
                if ("clusterType".equals(fieldName)) {
                    deserializedClusterProperties.clusterType = ClusterType.fromString(reader.getString());
                    continue;
                }
                if ("clusterVersion".equals(fieldName)) {
                    deserializedClusterProperties.clusterVersion = reader.getString();
                    continue;
                }
                if ("networkFabricId".equals(fieldName)) {
                    deserializedClusterProperties.networkFabricId = reader.getString();
                    continue;
                }
                if ("analyticsOutputSettings".equals(fieldName)) {
                    deserializedClusterProperties.analyticsOutputSettings = AnalyticsOutputSettings.fromJson(reader);
                    continue;
                }
                if ("analyticsWorkspaceId".equals(fieldName)) {
                    deserializedClusterProperties.analyticsWorkspaceId = reader.getString();
                    continue;
                }
                if ("availableUpgradeVersions".equals(fieldName)) {
                    List availableUpgradeVersions;
                    deserializedClusterProperties.availableUpgradeVersions = availableUpgradeVersions = reader.readArray(reader1 -> ClusterAvailableUpgradeVersion.fromJson(reader1));
                    continue;
                }
                if ("clusterCapacity".equals(fieldName)) {
                    deserializedClusterProperties.clusterCapacity = ClusterCapacity.fromJson(reader);
                    continue;
                }
                if ("clusterConnectionStatus".equals(fieldName)) {
                    deserializedClusterProperties.clusterConnectionStatus = ClusterConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("clusterExtendedLocation".equals(fieldName)) {
                    deserializedClusterProperties.clusterExtendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("clusterLocation".equals(fieldName)) {
                    deserializedClusterProperties.clusterLocation = reader.getString();
                    continue;
                }
                if ("clusterManagerConnectionStatus".equals(fieldName)) {
                    deserializedClusterProperties.clusterManagerConnectionStatus = ClusterManagerConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("clusterManagerId".equals(fieldName)) {
                    deserializedClusterProperties.clusterManagerId = reader.getString();
                    continue;
                }
                if ("clusterServicePrincipal".equals(fieldName)) {
                    deserializedClusterProperties.clusterServicePrincipal = ServicePrincipalInformation.fromJson(reader);
                    continue;
                }
                if ("commandOutputSettings".equals(fieldName)) {
                    deserializedClusterProperties.commandOutputSettings = CommandOutputSettings.fromJson(reader);
                    continue;
                }
                if ("computeDeploymentThreshold".equals(fieldName)) {
                    deserializedClusterProperties.computeDeploymentThreshold = ValidationThreshold.fromJson(reader);
                    continue;
                }
                if ("computeRackDefinitions".equals(fieldName)) {
                    List computeRackDefinitions;
                    deserializedClusterProperties.computeRackDefinitions = computeRackDefinitions = reader.readArray(reader1 -> RackDefinition.fromJson(reader1));
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedClusterProperties.detailedStatus = ClusterDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedClusterProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("hybridAksExtendedLocation".equals(fieldName)) {
                    deserializedClusterProperties.hybridAksExtendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("managedResourceGroupConfiguration".equals(fieldName)) {
                    deserializedClusterProperties.managedResourceGroupConfiguration = ManagedResourceGroupConfiguration.fromJson(reader);
                    continue;
                }
                if ("manualActionCount".equals(fieldName)) {
                    deserializedClusterProperties.manualActionCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterProperties.provisioningState = ClusterProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("runtimeProtectionConfiguration".equals(fieldName)) {
                    deserializedClusterProperties.runtimeProtectionConfiguration = RuntimeProtectionConfiguration.fromJson(reader);
                    continue;
                }
                if ("secretArchive".equals(fieldName)) {
                    deserializedClusterProperties.secretArchive = ClusterSecretArchive.fromJson(reader);
                    continue;
                }
                if ("secretArchiveSettings".equals(fieldName)) {
                    deserializedClusterProperties.secretArchiveSettings = SecretArchiveSettings.fromJson(reader);
                    continue;
                }
                if ("supportExpiryDate".equals(fieldName)) {
                    deserializedClusterProperties.supportExpiryDate = reader.getString();
                    continue;
                }
                if ("updateStrategy".equals(fieldName)) {
                    deserializedClusterProperties.updateStrategy = ClusterUpdateStrategy.fromJson(reader);
                    continue;
                }
                if ("vulnerabilityScanningSettings".equals(fieldName)) {
                    deserializedClusterProperties.vulnerabilityScanningSettings = VulnerabilityScanningSettings.fromJson(reader);
                    continue;
                }
                if ("workloadResourceIds".equals(fieldName)) {
                    List workloadResourceIds;
                    deserializedClusterProperties.workloadResourceIds = workloadResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterProperties;
        });
    }
}

