/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.CloudServicesNetworkProperties;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkEnableDefaultEgressEndpoints;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkProvisioningState;
import com.azure.resourcemanager.networkcloud.models.EgressEndpoint;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CloudServicesNetworkInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private CloudServicesNetworkProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(CloudServicesNetworkInner.class);

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public CloudServicesNetworkInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private CloudServicesNetworkProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public CloudServicesNetworkInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CloudServicesNetworkInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<EgressEndpoint> additionalEgressEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalEgressEndpoints();
    }

    public CloudServicesNetworkInner withAdditionalEgressEndpoints(List<EgressEndpoint> additionalEgressEndpoints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CloudServicesNetworkProperties();
        }
        this.innerProperties().withAdditionalEgressEndpoints(additionalEgressEndpoints);
        return this;
    }

    public List<String> associatedResourceIds() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedResourceIds();
    }

    public String clusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterId();
    }

    public CloudServicesNetworkDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().enableDefaultEgressEndpoints();
    }

    public CloudServicesNetworkInner withEnableDefaultEgressEndpoints(CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CloudServicesNetworkProperties();
        }
        this.innerProperties().withEnableDefaultEgressEndpoints(enableDefaultEgressEndpoints);
        return this;
    }

    public List<EgressEndpoint> enabledEgressEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledEgressEndpoints();
    }

    public List<String> hybridAksClustersAssociatedIds() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridAksClustersAssociatedIds();
    }

    public String interfaceName() {
        return this.innerProperties() == null ? null : this.innerProperties().interfaceName();
    }

    public CloudServicesNetworkProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<String> virtualMachinesAssociatedIds() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachinesAssociatedIds();
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model CloudServicesNetworkInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CloudServicesNetworkInner fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServicesNetworkInner)((Object)jsonReader.readObject(reader -> {
            CloudServicesNetworkInner deserializedCloudServicesNetworkInner = new CloudServicesNetworkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCloudServicesNetworkInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCloudServicesNetworkInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCloudServicesNetworkInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCloudServicesNetworkInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCloudServicesNetworkInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedCloudServicesNetworkInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCloudServicesNetworkInner.innerProperties = CloudServicesNetworkProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCloudServicesNetworkInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServicesNetworkInner;
        }));
    }
}

