/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.BmcKeySetProperties;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetPrivilegeLevel;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.KeySetUser;
import com.azure.resourcemanager.networkcloud.models.KeySetUserStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class BmcKeySetInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private BmcKeySetProperties innerProperties = new BmcKeySetProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(BmcKeySetInner.class);

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public BmcKeySetInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private BmcKeySetProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public BmcKeySetInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BmcKeySetInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String azureGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().azureGroupId();
    }

    public BmcKeySetInner withAzureGroupId(String azureGroupId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BmcKeySetProperties();
        }
        this.innerProperties().withAzureGroupId(azureGroupId);
        return this;
    }

    public BmcKeySetDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public OffsetDateTime expiration() {
        return this.innerProperties() == null ? null : this.innerProperties().expiration();
    }

    public BmcKeySetInner withExpiration(OffsetDateTime expiration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BmcKeySetProperties();
        }
        this.innerProperties().withExpiration(expiration);
        return this;
    }

    public OffsetDateTime lastValidation() {
        return this.innerProperties() == null ? null : this.innerProperties().lastValidation();
    }

    public BmcKeySetPrivilegeLevel privilegeLevel() {
        return this.innerProperties() == null ? null : this.innerProperties().privilegeLevel();
    }

    public BmcKeySetInner withPrivilegeLevel(BmcKeySetPrivilegeLevel privilegeLevel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BmcKeySetProperties();
        }
        this.innerProperties().withPrivilegeLevel(privilegeLevel);
        return this;
    }

    public BmcKeySetProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<KeySetUser> userList() {
        return this.innerProperties() == null ? null : this.innerProperties().userList();
    }

    public BmcKeySetInner withUserList(List<KeySetUser> userList) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BmcKeySetProperties();
        }
        this.innerProperties().withUserList(userList);
        return this;
    }

    public List<KeySetUserStatus> userListStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().userListStatus();
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model BmcKeySetInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model BmcKeySetInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BmcKeySetInner fromJson(JsonReader jsonReader) throws IOException {
        return (BmcKeySetInner)((Object)jsonReader.readObject(reader -> {
            BmcKeySetInner deserializedBmcKeySetInner = new BmcKeySetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBmcKeySetInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBmcKeySetInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBmcKeySetInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedBmcKeySetInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBmcKeySetInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedBmcKeySetInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBmcKeySetInner.innerProperties = BmcKeySetProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBmcKeySetInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBmcKeySetInner;
        }));
    }
}

